/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.servlet.response.mapper;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.sap.cloud.sdk.cloudplatform.servlet.response.LogLevel;
import com.sap.cloud.sdk.cloudplatform.servlet.response.ResponseWithErrorCode;

public interface ResponseMapper<T extends Throwable> //NOCHECKSTYLE
{
    @Nonnull
    Class<T> getThrowableClass();

    @Nullable
    ResponseWithErrorCode toResponse( @Nonnull final Throwable throwable );

    @Nullable
    LogLevel getLogLevel( @Nonnull final Throwable throwable );

    @Nullable
    String getErrorMessage( @Nonnull final Throwable throwable );
}
