/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderAccessor;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.servlet.LocaleFacade;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultLocaleFacade
implements LocaleFacade {
    private static final List<Locale> SYSTEM_LOCALES_DEFAULT = Collections.singletonList(Locale.getDefault());
    private static final List<Locale> SYSTEM_LOCALES_AVAILABLE = Arrays.asList(Locale.getAvailableLocales());

    @Override
    @Nonnull
    public List<Locale> getCurrentLocales() {
        List<Locale> localesByHeaders = this.getLocalesByHeaders();
        if (!localesByHeaders.isEmpty()) {
            return localesByHeaders;
        }
        return SYSTEM_LOCALES_DEFAULT;
    }

    @Nonnull
    private List<Locale> getLocalesByHeaders() {
        return ((RequestHeaderContainer)RequestHeaderAccessor.tryGetHeaderContainer().getOrElse((Object)RequestHeaderContainer.EMPTY)).getHeaderValues("Accept-Language").stream().map(this::getLocaleByString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Nullable
    private Locale getLocaleByString(@Nonnull String acceptLanguage) {
        List<Locale.LanguageRange> ranges = Locale.LanguageRange.parse(acceptLanguage);
        return Locale.lookup(ranges, SYSTEM_LOCALES_AVAILABLE);
    }
}

