/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.servlet.RequestThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import io.vavr.control.Option;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="RequestAccessorFilter", urlPatterns={"/*"})
public class RequestAccessorFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestAccessorFilter.class);

    public void init(@Nonnull FilterConfig filterConfig) {
    }

    public void doFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain filterChain) {
        if (request instanceof HttpServletRequest) {
            try {
                ThreadContextExecutor threadContextExecutor = new ThreadContextExecutor();
                Option existing = threadContextExecutor.getListener(-9);
                if (!existing.isDefined()) {
                    threadContextExecutor.withListeners(new ThreadContextListener[]{new RequestThreadContextListener((HttpServletRequest)request)});
                } else if (log.isWarnEnabled()) {
                    log.warn("Failed to add " + ThreadContextListener.class.getSimpleName() + ": listener " + ((ThreadContextListener)existing.get()).getClass().getName() + " with priority " + -9 + " already exists.");
                }
                threadContextExecutor.execute(() -> filterChain.doFilter(request, response));
            }
            catch (Throwable t) {
                log.warn("Unexpected servlet filter exception: " + t.getMessage(), t);
                throw new ShouldNotHappenException(t);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Failed to initialize " + ThreadContext.class.getSimpleName() + ": request not of type " + HttpServletRequest.class.getName() + ".");
        }
    }

    public void destroy() {
    }
}

