/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.servlet;

import com.sap.cloud.sdk.cloudplatform.exception.ShouldNotHappenException;
import com.sap.cloud.sdk.cloudplatform.requestheader.DefaultRequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderContainer;
import com.sap.cloud.sdk.cloudplatform.requestheader.RequestHeaderThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="RequestAccessorFilter", urlPatterns={"/*"})
public class RequestAccessorFilter
implements Filter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestAccessorFilter.class);
    static final String PROPERTY_SERVLET_REQUEST_SCHEME = "servlet-scheme";
    static final String PROPERTY_SERVLET_REQUEST_PRINCIPAL_NAME = "servlet-principal-name";
    static final String PROPERTY_SERVLET_REQUEST_REMOTE_ADDRESS = "servlet-remote-address";
    @Deprecated
    public static final String PROPERTY_SERVLET_SCHEME = RequestAccessorFilter.class.getName() + ":servlet-scheme";
    @Deprecated
    public static final String PROPERTY_SERVLET_PRINCIPAL_NAME = RequestAccessorFilter.class.getName() + ":servlet-principal-name";
    @Deprecated
    public static final String PROPERTY_SERVLET_REMOTE_ADDRESS = RequestAccessorFilter.class.getName() + ":servlet-remote-address";

    public void init(@Nonnull FilterConfig filterConfig) {
    }

    public void doFilter(@Nonnull ServletRequest request, @Nonnull ServletResponse response, @Nonnull FilterChain filterChain) {
        if (request instanceof HttpServletRequest) {
            try {
                HttpServletRequest httpRequest = (HttpServletRequest)request;
                DefaultThreadContext threadContext = new DefaultThreadContext();
                this.storeServletProperties(httpRequest, (ThreadContext)threadContext);
                ThreadContextExecutor.using((ThreadContext)threadContext).execute(() -> filterChain.doFilter(request, response));
            }
            catch (Throwable t) {
                log.warn("Unexpected servlet filter exception: " + t.getMessage(), t);
                throw new ShouldNotHappenException(t);
            }
        } else if (log.isWarnEnabled()) {
            log.warn("Failed to initialize " + ThreadContext.class.getSimpleName() + ": request not of type " + HttpServletRequest.class.getName() + ".");
        }
    }

    private void storeServletProperties(@Nonnull HttpServletRequest servlet, @Nonnull ThreadContext threadContext) {
        threadContext.setPropertyIfAbsent(PROPERTY_SERVLET_REQUEST_SCHEME, Property.decorateCallable(() -> ((HttpServletRequest)servlet).getScheme()));
        threadContext.setPropertyIfAbsent(PROPERTY_SERVLET_REQUEST_PRINCIPAL_NAME, Property.decorateCallable(() -> servlet.getUserPrincipal().getName()));
        threadContext.setPropertyIfAbsent(PROPERTY_SERVLET_REQUEST_REMOTE_ADDRESS, () -> Property.ofTry((Try)Try.of(() -> ((HttpServletRequest)servlet).getRemoteAddr())));
        threadContext.setPropertyIfAbsent(RequestHeaderThreadContextListener.PROPERTY_REQUEST_HEADERS, Property.decorateCallable(() -> RequestAccessorFilter.extractHeaders(servlet)));
    }

    @Nonnull
    private static RequestHeaderContainer extractHeaders(@Nonnull HttpServletRequest request) {
        Enumeration headerNames = request.getHeaderNames();
        if (headerNames == null) {
            return RequestHeaderContainer.EMPTY;
        }
        HashMap headers = new HashMap();
        while (headerNames.hasMoreElements()) {
            Option headerName = Option.of((Object)((String)headerNames.nextElement()));
            headerName.map(arg_0 -> ((HttpServletRequest)request).getHeaders(arg_0)).filter(Objects::nonNull).peek(values -> headers.put((String)headerName.get(), Collections.list(values)));
        }
        return DefaultRequestHeaderContainer.fromMultiValueMap(headers);
    }

    public void destroy() {
    }
}

