/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpCfTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfTenantFacade
extends DefaultTenantFacade {
    private static final Logger log = LoggerFactory.getLogger(ScpCfTenantFacade.class);
    private static final String JWT_ZONE_ID = "zid";
    private static final String JWT_ISSUER = "iss";

    @Nonnull
    private String getTenantId(@Nonnull Payload jwt) {
        String tenantId = jwt.getClaim(JWT_ZONE_ID).asString();
        if (tenantId == null) {
            throw new TenantAccessException("No tenant identifier ('zid' element) found in JWT.");
        }
        return tenantId;
    }

    @Nonnull
    private String getIssuer(@Nonnull DecodedJWT jwt) {
        String issuer = jwt.getClaim(JWT_ISSUER).asString();
        if (issuer == null) {
            throw new TenantAccessException("No subdomain ('iss' element) found in JWT.");
        }
        return issuer;
    }

    @Nonnull
    private String getSubdomain(@Nonnull URI issuerUri) {
        String host = issuerUri.getHost();
        if (host == null || !host.contains(".")) {
            throw new TenantAccessException("Failed to get subdomain from issuer URI '" + issuerUri + "'.");
        }
        return host.split("\\.")[0];
    }

    @Nonnull
    private Try<Tenant> tryGetTenant(@Nonnull Try<AuthToken> authToken) {
        return super.tryGetCurrentTenant().orElse(() -> {
            Try jwtTry = authToken.map(AuthToken::getJwt);
            if (jwtTry.isFailure()) {
                return Try.failure((Throwable)jwtTry.getCause());
            }
            Try tenantIdTry = jwtTry.map(this::getTenantId);
            if (tenantIdTry.isFailure()) {
                return Try.failure((Throwable)tenantIdTry.getCause());
            }
            Try subdomainTry = jwtTry.map(this::getIssuer).map(URI::create).map(this::getSubdomain);
            if (subdomainTry.isFailure()) {
                return Try.failure((Throwable)subdomainTry.getCause());
            }
            return Try.of((CheckedFunction0 & Serializable)() -> new ScpCfTenant((String)tenantIdTry.get(), (String)subdomainTry.get()));
        });
    }

    @Nonnull
    public Try<Tenant> tryGetAuthTokenTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenant((Try<AuthToken>)AuthTokenAccessor.tryGetCurrentToken()));
    }

    @Nonnull
    public Try<Tenant> tryGetXsuaaServiceTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenant((Try<AuthToken>)AuthTokenAccessor.tryGetXsuaaServiceToken()));
    }

    @Nonnull
    public Try<Tenant> tryGetCurrentTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenant((Try<AuthToken>)AuthTokenAccessor.tryGetCurrentToken().orElse(AuthTokenAccessor::tryGetXsuaaServiceToken)));
    }
}

