/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.Payload;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.CloudPlatform;
import com.sap.cloud.sdk.cloudplatform.CloudPlatformAccessor;
import com.sap.cloud.sdk.cloudplatform.ScpCfCloudPlatform;
import com.sap.cloud.sdk.cloudplatform.exception.CloudPlatformException;
import com.sap.cloud.sdk.cloudplatform.security.AuthToken;
import com.sap.cloud.sdk.cloudplatform.security.AuthTokenAccessor;
import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpCfTenant;
import com.sap.cloud.sdk.cloudplatform.tenant.ServiceBindingTenantExtractor;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScpCfTenantFacade
extends DefaultTenantFacade {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScpCfTenantFacade.class);
    private static final String XSUAA_JWT_ZONE_ID = "zid";
    private static final String IAS_JWT_ZONE_ID = "zone_uuid";
    private static final List<String> TENANT_ID_CLAIMS = Arrays.asList("zid", "zone_uuid");
    private static final String JWT_ISSUER = "iss";

    @Nonnull
    private String getTenantId(@Nonnull Payload jwt) {
        Optional<String> maybeTenantId = TENANT_ID_CLAIMS.stream().map(id -> jwt.getClaim(id).asString()).filter(Objects::nonNull).findFirst();
        if (!maybeTenantId.isPresent()) {
            throw new TenantAccessException("No tenant/zone identifier (one of these elements [" + TENANT_ID_CLAIMS.toString() + "]) found in JWT.");
        }
        return maybeTenantId.get();
    }

    @Nonnull
    private String getIssuer(@Nonnull DecodedJWT jwt) {
        String issuer = jwt.getClaim(JWT_ISSUER).asString();
        if (issuer == null) {
            throw new TenantAccessException("No subdomain ('iss' element) found in JWT.");
        }
        return issuer;
    }

    @Nonnull
    private String getSubdomain(@Nonnull URI issuerUri) {
        String host = issuerUri.getHost();
        if (host == null || !host.contains(".")) {
            throw new TenantAccessException("Failed to get subdomain from issuer URI '" + issuerUri + "'.");
        }
        return host.split("\\.")[0];
    }

    @Nonnull
    private Try<Tenant> tryGetTenantFromAuthToken(@Nonnull Try<AuthToken> authToken) {
        return super.tryGetCurrentTenant().orElse(() -> {
            Try jwtTry = authToken.map(AuthToken::getJwt);
            if (jwtTry.isFailure()) {
                return Try.failure((Throwable)jwtTry.getCause());
            }
            Try tenantIdTry = jwtTry.map(this::getTenantId);
            if (tenantIdTry.isFailure()) {
                return Try.failure((Throwable)tenantIdTry.getCause());
            }
            Try subdomainTry = jwtTry.map(this::getIssuer).map(URI::create).map(this::getSubdomain);
            if (subdomainTry.isFailure()) {
                return Try.failure((Throwable)subdomainTry.getCause());
            }
            return Try.of((CheckedFunction0 & Serializable)() -> new ScpCfTenant((String)tenantIdTry.get(), (String)subdomainTry.get()));
        });
    }

    @Nonnull
    public Try<Tenant> tryGetAuthTokenTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenantFromAuthToken((Try<AuthToken>)AuthTokenAccessor.tryGetCurrentToken()));
    }

    @Nonnull
    public Try<Tenant> tryGetXsuaaServiceTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenantFromAuthToken((Try<AuthToken>)AuthTokenAccessor.tryGetXsuaaServiceToken()));
    }

    @Nonnull
    public Try<Tenant> tryGetCurrentTenant() {
        return super.tryGetCurrentTenant().orElse(() -> this.tryGetTenantFromAuthToken((Try<AuthToken>)AuthTokenAccessor.tryGetCurrentToken())).orElse(() -> this.tryGetTenantFromServiceBinding((Try<CloudPlatform>)CloudPlatformAccessor.tryGetCloudPlatform())).orElse(() -> this.tryGetTenantFromAuthToken((Try<AuthToken>)AuthTokenAccessor.tryGetXsuaaServiceToken()));
    }

    @Nonnull
    private Try<ScpCfTenant> tryGetTenantFromServiceBinding(@Nonnull Try<CloudPlatform> platform) {
        for (ServiceBindingTenantExtractor extractor : ServiceBindingTenantExtractor.values()) {
            Try bindings = platform.map(ScpCfCloudPlatform.class::cast).map(p -> p.getServiceCredentialsByPlan(extractor.getService(), filter -> true).values()).map(Iterables::concat);
            if (bindings.isFailure()) {
                log.debug("Unable to parse service bindings for {}.", (Object)extractor.getService(), (Object)bindings.getCause());
                continue;
            }
            Optional tenant = Streams.stream((Iterable)((Iterable)bindings.get())).peek(obj -> log.trace("Trying to extract tenant information from service binding {}.", obj)).flatMap(obj -> extractor.getExtractor().apply((JsonObject)obj).toJavaStream()).findFirst();
            if (!tenant.isPresent()) continue;
            return Try.success(tenant.get());
        }
        return Try.failure((Throwable)new CloudPlatformException("Failed to extract tenant from service bindings."));
    }
}

