/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.sap.cloud.sdk.cloudplatform.tenant.ScpCfTenant;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;

enum ServiceBindingTenantExtractor {
    XSUAA("xsuaa", new Extraction().subdomain("identityzone").tenantId("identityzoneid").tenantId("zoneid").tenantId("tenantid")),
    IAS("identity", new Extraction().subdomain("url", s -> (String)Try.of((CheckedFunction0 & Serializable)() -> URI.create(s).getHost()).map(h -> h.substring(0, h.indexOf(46))).getOrElse((Object)"")).tenantId("zone_uuid"));

    @Nonnull
    private final String service;
    @Nonnull
    private final Function<JsonObject, Option<ScpCfTenant>> extractor;

    @Generated
    private ServiceBindingTenantExtractor(String service, Function<JsonObject, Option<ScpCfTenant>> extractor) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.service = service;
        this.extractor = extractor;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ServiceBindingTenantExtractor." + this.name() + "(service=" + this.getService() + ")";
    }

    @Nonnull
    @Generated
    public String getService() {
        return this.service;
    }

    @Nonnull
    @Generated
    public Function<JsonObject, Option<ScpCfTenant>> getExtractor() {
        return this.extractor;
    }

    private static class Extraction
    implements Function<JsonObject, Option<ScpCfTenant>> {
        private Function<JsonObject, Option<String>> tenantIdLogic = obj -> Option.none();
        private Function<JsonObject, Option<String>> subdomainLogic = obj -> Option.none();

        private Extraction() {
        }

        public Extraction tenantId(@Nonnull String key) {
            return this.tenantId(key, Function.identity());
        }

        public Extraction tenantId(@Nonnull String key, @Nonnull Function<String, String> refiner) {
            this.tenantIdLogic = Extraction.concatLogic(this.tenantIdLogic, key, refiner);
            return this;
        }

        public Extraction subdomain(@Nonnull String key) {
            return this.subdomain(key, Function.identity());
        }

        public Extraction subdomain(@Nonnull String key, @Nonnull Function<String, String> refiner) {
            this.subdomainLogic = Extraction.concatLogic(this.subdomainLogic, key, refiner);
            return this;
        }

        @Nonnull
        private static Function<JsonObject, Option<String>> concatLogic(@Nonnull Function<JsonObject, Option<String>> logic, @Nonnull String key, @Nonnull Function<String, String> f) {
            return o -> ((Option)logic.apply((JsonObject)o)).orElse(() -> Option.of((Object)o.get(key)).filter(JsonElement::isJsonPrimitive).map(JsonElement::getAsString).map(f));
        }

        @Override
        public Option<ScpCfTenant> apply(JsonObject obj) {
            Option<String> subdomain = this.subdomainLogic.apply(obj);
            Option<String> tenantId = this.tenantIdLogic.apply(obj);
            return tenantId.flatMap(id -> subdomain.map(domain -> new ScpCfTenant((String)id, (String)domain)));
        }
    }
}

