/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.cloudplatform.tenant;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextAccessor;

import io.vavr.control.Try;

/**
 * Abstract base class for {@link TenantFacade}s.
 */
public class DefaultTenantFacade implements TenantFacade
{
    /**
     * {@inheritDoc}
     */
    @Nonnull
    @Override
    public Try<Tenant> tryGetCurrentTenant()
    {
        return ThreadContextAccessor
            .tryGetCurrentContext()
            .flatMap(context -> context.<Tenant> getProperty(TenantThreadContextListener.PROPERTY_TENANT))
            .map(Property::getValue);
    }
}
