/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.DefaultThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextExecutor;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAccessor.class);
    @Nonnull
    private static Try<TenantFacade> tenantFacade = FacadeLocator.getFacade(TenantFacade.class);
    @Nullable
    private static Supplier<Tenant> fallbackTenant = null;

    @Nullable
    public static TenantFacade getTenantFacade() {
        return (TenantFacade)tenantFacade.getOrNull();
    }

    @Nonnull
    public static Try<TenantFacade> tryGetTenantFacade() {
        return tenantFacade;
    }

    public static void setTenantFacade(@Nullable TenantFacade tenantFacade) {
        TenantAccessor.tenantFacade = tenantFacade == null ? FacadeLocator.getFacade(TenantFacade.class) : Try.success((Object)tenantFacade);
    }

    @Nonnull
    public static Tenant getCurrentTenant() throws TenantAccessException {
        return (Tenant)TenantAccessor.tryGetCurrentTenant().getOrElseThrow(failure -> {
            if (failure instanceof TenantAccessException) {
                throw (TenantAccessException)failure;
            }
            throw new TenantAccessException("Failed to get current tenant.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<Tenant> tryGetCurrentTenant() {
        Try tenantTry = tenantFacade.flatMap(TenantFacade::tryGetCurrentTenant);
        if (tenantTry.isFailure() && fallbackTenant != null) {
            return tenantTry.recover(failure -> {
                Tenant fallback = fallbackTenant.get();
                if (log.isWarnEnabled()) {
                    log.warn("Recovering with fallback tenant: " + fallback + ".", failure);
                }
                return fallback;
            });
        }
        return tenantTry;
    }

    @Nullable
    public static <T> T executeWithTenant(@Nonnull Tenant tenant, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        return (T)((ThreadContextExecutor)((ThreadContextExecutor)new ThreadContextExecutor().withThreadContext((ThreadContext)new DefaultThreadContext())).withListeners(new ThreadContextListener[]{new TenantThreadContextListener(tenant)})).execute(callable);
    }

    public static void executeWithTenant(@Nonnull Tenant tenant, @Nonnull Executable executable) throws ThreadContextExecutionException {
        TenantAccessor.executeWithTenant(tenant, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackTenant(@Nonnull Supplier<Tenant> fallbackTenant, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<Tenant> tenantTry = TenantAccessor.tryGetCurrentTenant();
        if (tenantTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return TenantAccessor.executeWithTenant(fallbackTenant.get(), callable);
    }

    public static void executeWithFallbackTenant(@Nonnull Supplier<Tenant> fallbackTenant, @Nonnull Executable executable) throws ThreadContextExecutionException {
        TenantAccessor.executeWithFallbackTenant(fallbackTenant, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private TenantAccessor() {
    }

    @Nullable
    @Generated
    public static Supplier<Tenant> getFallbackTenant() {
        return fallbackTenant;
    }

    @Generated
    public static void setFallbackTenant(@Nullable Supplier<Tenant> fallbackTenant) {
        TenantAccessor.fallbackTenant = fallbackTenant;
    }
}

