/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantAccessor;
import com.sap.cloud.sdk.cloudplatform.thread.Property;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContext;
import com.sap.cloud.sdk.cloudplatform.thread.ThreadContextListener;
import io.vavr.control.Try;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TenantThreadContextListener
implements ThreadContextListener {
    public static final String PROPERTY_TENANT = TenantThreadContextListener.class.getName() + ":tenant";
    @Nullable
    private final Tenant tenant;

    public TenantThreadContextListener() {
        this.tenant = null;
    }

    public TenantThreadContextListener(@Nonnull Tenant tenant) {
        this.tenant = tenant;
    }

    public int getPriority() {
        return -3;
    }

    public void afterInitialize(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        Try tenantTry = this.tenant != null ? Try.success((Object)this.tenant) : (parentThreadContext != null ? parentThreadContext.getProperty(PROPERTY_TENANT).map(Property::getValue).orElse(TenantAccessor.tryGetCurrentTenant()) : TenantAccessor.tryGetCurrentTenant());
        threadContext.setPropertyIfAbsent(PROPERTY_TENANT, Property.ofTry(tenantTry));
    }

    public void beforeDestroy(@Nonnull ThreadContext threadContext, @Nullable ThreadContext parentThreadContext) {
        threadContext.removeProperty(PROPERTY_TENANT);
    }
}

