/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenant;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;

enum ServiceBindingTenantExtractor {
    XSUAA("xsuaa", new Extraction().subdomain("identityzone").tenantId("identityzoneid").tenantId("zoneid").tenantId("tenantid")),
    IAS("identity", new Extraction().subdomain("url", s -> (String)Try.of((CheckedFunction0 & Serializable)() -> URI.create(s).getHost()).map(h -> h.substring(0, h.indexOf(46))).getOrElse((Object)"")).tenantId("app_tid").tenantId("zone_uuid"));

    @Nonnull
    private final String service;
    @Nonnull
    private final Function<Map<String, Object>, Option<DefaultTenant>> extractor;

    @Generated
    private ServiceBindingTenantExtractor(String service, Function<Map<String, Object>, Option<DefaultTenant>> extractor) {
        if (service == null) {
            throw new NullPointerException("service is marked non-null but is null");
        }
        if (extractor == null) {
            throw new NullPointerException("extractor is marked non-null but is null");
        }
        this.service = service;
        this.extractor = extractor;
    }

    @Nonnull
    @Generated
    public String toString() {
        return "ServiceBindingTenantExtractor." + this.name() + "(service=" + this.getService() + ")";
    }

    @Nonnull
    @Generated
    public String getService() {
        return this.service;
    }

    @Nonnull
    @Generated
    public Function<Map<String, Object>, Option<DefaultTenant>> getExtractor() {
        return this.extractor;
    }

    private static class Extraction
    implements Function<Map<String, Object>, Option<DefaultTenant>> {
        private Function<Map<String, Object>, Option<String>> tenantIdLogic = obj -> Option.none();
        private Function<Map<String, Object>, Option<String>> subdomainLogic = obj -> Option.none();

        private Extraction() {
        }

        public Extraction tenantId(@Nonnull String key) {
            return this.tenantId(key, Function.identity());
        }

        public Extraction tenantId(@Nonnull String key, @Nonnull Function<String, String> refiner) {
            this.tenantIdLogic = Extraction.concatLogic(this.tenantIdLogic, key, refiner);
            return this;
        }

        public Extraction subdomain(@Nonnull String key) {
            return this.subdomain(key, Function.identity());
        }

        public Extraction subdomain(@Nonnull String key, @Nonnull Function<String, String> refiner) {
            this.subdomainLogic = Extraction.concatLogic(this.subdomainLogic, key, refiner);
            return this;
        }

        @Nonnull
        private static Function<Map<String, Object>, Option<String>> concatLogic(@Nonnull Function<Map<String, Object>, Option<String>> logic, @Nonnull String key, @Nonnull Function<String, String> f) {
            return o -> ((Option)logic.apply((Map<String, Object>)o)).orElse(() -> Option.of(o.get(key)).filter(value -> value instanceof String).map(value -> (String)value).map(f));
        }

        @Override
        public Option<DefaultTenant> apply(Map<String, Object> obj) {
            Option<String> subdomain = this.subdomainLogic.apply(obj);
            Option<String> tenantId = this.tenantIdLogic.apply(obj);
            return tenantId.flatMap(id -> subdomain.map(domain -> new DefaultTenant((String)id, (String)domain)));
        }
    }
}

