/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.cloudplatform.tenant;

import com.sap.cloud.sdk.cloudplatform.tenant.DefaultTenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.Tenant;
import com.sap.cloud.sdk.cloudplatform.tenant.TenantFacade;
import com.sap.cloud.sdk.cloudplatform.tenant.exception.TenantAccessException;
import com.sap.cloud.sdk.cloudplatform.thread.Executable;
import com.sap.cloud.sdk.cloudplatform.thread.exception.ThreadContextExecutionException;
import com.sap.cloud.sdk.cloudplatform.util.FacadeLocator;
import io.vavr.control.Try;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TenantAccessor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TenantAccessor.class);
    @Nonnull
    private static TenantFacade tenantFacade = TenantAccessor.loadFacadeOrDefault();
    @Nullable
    private static Supplier<Tenant> fallbackTenant = null;

    @Nonnull
    public static TenantFacade getTenantFacade() {
        return tenantFacade;
    }

    @Nonnull
    public static Try<TenantFacade> tryGetTenantFacade() {
        return Try.success((Object)tenantFacade);
    }

    public static void setTenantFacade(@Nullable TenantFacade tenantFacade) {
        TenantAccessor.tenantFacade = tenantFacade == null ? TenantAccessor.loadFacadeOrDefault() : tenantFacade;
    }

    private static TenantFacade loadFacadeOrDefault() {
        return (TenantFacade)FacadeLocator.getFacade(TenantFacade.class).getOrElseGet(e -> {
            log.debug("No TenantFacade found via FacadeLocator. Falling back to DefaultTenantFacade.");
            return new DefaultTenantFacade();
        });
    }

    @Nonnull
    public static Tenant getCurrentTenant() throws TenantAccessException {
        return (Tenant)TenantAccessor.tryGetCurrentTenant().getOrElseThrow(failure -> {
            if (failure instanceof TenantAccessException) {
                throw (TenantAccessException)failure;
            }
            throw new TenantAccessException("Failed to get current tenant.", (Throwable)failure);
        });
    }

    @Nonnull
    public static Try<Tenant> tryGetCurrentTenant() {
        Try<Tenant> tenantTry = tenantFacade.tryGetCurrentTenant();
        if (tenantTry.isSuccess() || fallbackTenant == null) {
            return tenantTry;
        }
        Tenant fallback = fallbackTenant.get();
        if (fallback == null) {
            return Try.failure((Throwable)new TenantAccessException());
        }
        return tenantTry.recover(failure -> {
            log.warn("Recovering with fallback tenant: {}.", (Object)fallback, failure);
            return fallback;
        });
    }

    @Nullable
    public static <T> T executeWithTenant(@Nonnull Tenant tenant, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        TenantFacade maybeTenantFacade = TenantAccessor.getTenantFacade();
        if (maybeTenantFacade == null || !DefaultTenantFacade.class.isAssignableFrom(maybeTenantFacade.getClass())) {
            throw new ThreadContextExecutionException(String.format("The 'executeWith...' API is currently supported only when using the Cloud SDK's 'DefaultFacade' implementations (e.g. '%s'). This is an issue especially when using the CAP integration ('cds-integration-cloud-sdk'). To workaround this shortcoming, please refer to the CAP documentation about how to manipulate the request context: https://cap.cloud.sap/docs/java/request-contexts#defining-requestcontext.", DefaultTenantFacade.class.getName()));
        }
        return ((DefaultTenantFacade)maybeTenantFacade).executeWithTenant(tenant, callable);
    }

    public static void executeWithTenant(@Nonnull Tenant tenant, @Nonnull Executable executable) throws ThreadContextExecutionException {
        TenantAccessor.executeWithTenant(tenant, () -> {
            executable.execute();
            return null;
        });
    }

    @Nullable
    public static <T> T executeWithFallbackTenant(@Nonnull Supplier<Tenant> fallbackTenant, @Nonnull Callable<T> callable) throws ThreadContextExecutionException {
        Try<Tenant> tenantTry = TenantAccessor.tryGetCurrentTenant();
        if (tenantTry.isSuccess()) {
            try {
                return callable.call();
            }
            catch (ThreadContextExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ThreadContextExecutionException((Throwable)e);
            }
        }
        return TenantAccessor.executeWithTenant(fallbackTenant.get(), callable);
    }

    public static void executeWithFallbackTenant(@Nonnull Supplier<Tenant> fallbackTenant, @Nonnull Executable executable) throws ThreadContextExecutionException {
        TenantAccessor.executeWithFallbackTenant(fallbackTenant, () -> {
            executable.execute();
            return null;
        });
    }

    @Generated
    private TenantAccessor() {
    }

    @Nullable
    @Generated
    public static Supplier<Tenant> getFallbackTenant() {
        return fallbackTenant;
    }

    @Generated
    public static void setFallbackTenant(@Nullable Supplier<Tenant> fallbackTenant) {
        TenantAccessor.fallbackTenant = fallbackTenant;
    }
}

