/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

/**
 * Descriptor for protocol specific information on deserializing OData responses.
 */
@Beta
public interface ODataResponseDescriptor
{
    /**
     * The JSON path to a set of result elements. The last element of this array refers to the result array.
     * 
     * @return The path to result set.
     */
    @Nonnull
    String[] getPathToResultSet();

    /**
     * The JSON path to a result object. The last element of this array refers to the result object.
     * 
     * @return The path to single result.
     */
    @Nonnull
    String[] getPathToResultSingle();

    /**
     * The JSON path to a result primitive. The last element of this array refers to the result value.
     *
     * @return The path to primitive result.
     */
    @Nonnull
    String[] getPathToResultPrimitive();

    /**
     * The JSON path to an inline count. The last element of this array refers to the result value.
     *
     * @return The path to inline count value.
     */
    @Nonnull
    String[] getPathToInlineCount();
}
