/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.expression;

import java.time.OffsetDateTime;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

import lombok.RequiredArgsConstructor;
import lombok.experimental.Delegate;

/**
 * OData filter expression operand of type Edm.DateTimeOffset
 */
@Beta
public interface ValueDateTimeOffset
    extends
    Expressions.OperandSingle,
    FilterableDateTimeOffset,
    FilterableComparisonAbsolute,
    FilterableComparisonRelative
{
    @Nonnull
    static ValueDateTimeOffset literal( @Nonnull final OffsetDateTime v )
    {
        return ( protocol, prefixes ) -> protocol.getDateTimeOffsetSerializer().apply(v);
    }

    @RequiredArgsConstructor
    class Expression implements FilterExpression, ValueDateTimeOffset
    {
        @Delegate
        private final FilterExpression delegate;
    }
}
