/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

/**
 * OData filter expression operand of enumeration type
 */
@Beta
public interface ValueEnum extends Expressions.OperandSingle, FilterableComparisonAbsolute
{
    @Nonnull
    static ValueEnum literal( @Nonnull final String v )
    {
        return ( protocol, prefixes ) -> "'" + v + "'";
    }

    @Nonnull
    static ValueEnum literal( @Nonnull final String enumType, @Nonnull final String v )
    {
        return ( protocol, prefixes ) -> enumType + "'" + v + "'";
    }
}
