/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.expression;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

import lombok.RequiredArgsConstructor;
import lombok.experimental.Delegate;

/**
 * OData filter expression operand of type Edm.String
 */
@Beta
public interface ValueString
    extends
    Expressions.OperandSingle,
    FilterableString,
    FilterableComparisonAbsolute,
    FilterableComparisonRelative
{
    @Nonnull
    static ValueString literal( @Nonnull final String v )
    {
        final String escapedValue = v.replaceAll("'", "''");
        return ( protocol, prefixes ) -> "'" + escapedValue + "'";
    }

    @RequiredArgsConstructor
    class Expression implements FilterExpression, ValueString
    {
        @Delegate
        private final FilterExpression delegate;
    }
}
