/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.query;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

@Beta
public interface QuerySerializable
{
    /**
     * Compute the encoded string representation of this query. The characters '%','/','$',' ','&','#','?','\','"' are
     * encoded, Other special characters are not encoded
     * 
     * @return A string representing the encoded request query.
     */
    @Nonnull
    String getEncodedQueryString();

    /**
     * Compute the string representation of this query
     *
     * @return A string representing the request query
     */
    @Nonnull
    String getQueryString();
}
