/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.request;

import java.net.URI;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;

import lombok.EqualsAndHashCode;

/**
 * The result type of the OData Count request.
 */
@EqualsAndHashCode( callSuper = true )
@Beta
public class ODataRequestCount extends ODataRequestRead
{
    /**
     * Default constructor for OData Count request.
     * 
     * @param servicePath
     *            The OData service path.
     * @param entityName
     *            The OData entity name.
     * @param queryString
     *            The HTTP query string.
     * @param protocol
     *            The OData protocol to use.
     */
    public ODataRequestCount(
        @Nonnull final String servicePath,
        @Nonnull final String entityName,
        @Nonnull final String queryString,
        @Nonnull final ODataProtocol protocol )
    {
        super(servicePath, entityName, queryString, protocol);
    }

    @Nonnull
    @Override
    public URI getRelativeUri()
    {
        final String urlPartEntity = getEntityName() + "/$count";
        return ODataUriFactory.getUriWithEncodedQuery(getServicePath(), urlPartEntity, getRequestQuery());
    }
}
