/*
 * Copyright (c) 2020 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.request;

import javax.annotation.Nonnull;

import org.apache.http.HttpResponse;

import com.google.common.annotations.Beta;

/**
 * Generic type of an OData request result.
 */
@Beta
public interface ODataRequestResult
{
    /**
     * Get the original {@link ODataRequestExecutable} instance that was used for running the OData request.
     *
     * @return The original {@link ODataRequestExecutable} instance.
     */
    @Nonnull
    ODataRequestExecutable getODataRequest();

    /**
     * Get the original OData {@link HttpResponse} instance, which holds the HttpEntity and header information.
     *
     * @return The HttpResponse.
     */
    @Nonnull
    HttpResponse getHttpResponse();

    /**
     * Get the iterable list of HTTP response header names.
     *
     * @return An iterable set of header names.
     */
    @Nonnull
    Iterable<String> getHeaderNames();

    /**
     * Get the iterable HTTP header values for a specific header name.
     *
     * @param headerName
     *            The header name to look for.
     * @return An iterable set of header values.
     */
    @Nonnull
    Iterable<String> getHeaderValues( @Nonnull final String headerName );
}
