/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.request.AbstractPathParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

@Beta
public final class ODataResourcePath {
    @Nonnull
    private final List<Tuple2<String, AbstractPathParameters>> path = new ArrayList<Tuple2<String, AbstractPathParameters>>();

    @Nonnull
    public static ODataResourcePath of(@Nonnull String segment) {
        return new ODataResourcePath().addSegment(segment);
    }

    @Nonnull
    public static ODataResourcePath of(@Nonnull String segment, @Nonnull AbstractPathParameters segmentParameter) {
        return new ODataResourcePath().addSegment(segment, segmentParameter);
    }

    @Nonnull
    public ODataResourcePath addSegment(@Nonnull String segment) {
        this.path.add((Tuple2<String, AbstractPathParameters>)Tuple.of((Object)segment, null));
        return this;
    }

    @Nonnull
    public ODataResourcePath addSegment(@Nonnull String segment, @Nonnull AbstractPathParameters parameters) {
        this.path.add((Tuple2<String, AbstractPathParameters>)Tuple.of((Object)segment, (Object)parameters));
        return this;
    }

    @Nonnull
    public ODataResourcePath addParameterToLastSegment(@Nonnull AbstractPathParameters parameters) {
        if (this.path.isEmpty()) {
            throw new IllegalStateException("Cannot add parameter to the last segment because the current path is empty.");
        }
        Tuple2<String, AbstractPathParameters> lastSegment = this.path.get(this.path.size() - 1);
        if (lastSegment._2() != null) {
            String msg = String.format("Cannot add parameter for path segment \"%s\". The segment already contains a parameter expression.", lastSegment._2());
            throw new IllegalStateException(msg);
        }
        this.path.set(this.path.size() - 1, (Tuple2<String, AbstractPathParameters>)lastSegment.update2((Object)parameters));
        return this;
    }

    @Nonnull
    public String toEncodedPathString() {
        return "/" + this.path.stream().map(t -> t.map1(ODataUriFactory::encodePathSegment)).map(t -> t.map2(key -> key != null ? key.toEncodedString() : "")).map(t -> (String)t._1() + (String)t._2()).collect(Collectors.joining("/"));
    }

    @Nonnull
    public String toString() {
        return "/" + this.path.stream().map(t -> t.map2(key -> key != null ? key.toString() : "")).map(t -> (String)t._1() + (String)t._2()).collect(Collectors.joining("/"));
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataResourcePath)) {
            return false;
        }
        ODataResourcePath other = (ODataResourcePath)o;
        List<Tuple2<String, AbstractPathParameters>> this$path = this.path;
        List<Tuple2<String, AbstractPathParameters>> other$path = other.path;
        return !(this$path == null ? other$path != null : !((Object)this$path).equals(other$path));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tuple2<String, AbstractPathParameters>> $path = this.path;
        result = result * 59 + ($path == null ? 43 : ((Object)$path).hashCode());
        return result;
    }
}

