/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import io.vavr.Tuple;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import lombok.Generated;

@Beta
public abstract class AbstractPathParameters {
    @Nonnull
    protected final Map<String, Expressions.OperandSingle> parameters = new LinkedHashMap<String, Expressions.OperandSingle>();
    @Nonnull
    private final ODataProtocol protocol;

    <PrimitiveT> void addParameterInternal(@Nonnull String parameterName, @Nonnull PrimitiveT value) {
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException("Cannot add parameter \"" + parameterName + "\": A parameter by that name already exists.");
        }
        this.parameters.put(parameterName, Expressions.createOperand(value));
    }

    void addParameterSetInternal(@Nonnull Map<String, Object> properties) {
        properties.entrySet().stream().filter(entry -> entry.getValue() == null).findFirst().ifPresent(entry -> {
            throw new IllegalArgumentException("Null value found for property \"" + (String)entry.getKey() + "\". Key-value pairs must not contain null values.");
        });
        properties.forEach(this::addParameterInternal);
    }

    @Nonnull
    public String toEncodedString() {
        return this.toStringInternal(true);
    }

    @Nonnull
    public String toString() {
        return this.toStringInternal(false);
    }

    @Nonnull
    private String toStringInternal(boolean applyEncoding) {
        if (this.parameters.size() == 1) {
            Expressions.OperandSingle singleValue = this.parameters.values().iterator().next();
            String parameterValue = singleValue.getExpression(this.protocol);
            parameterValue = applyEncoding ? ODataUriFactory.encodePathSegment(parameterValue) : parameterValue;
            parameterValue = String.format("(%s)", parameterValue);
            return parameterValue;
        }
        String keys = this.parameters.entrySet().stream().map(param -> Tuple.of(param.getKey(), param.getValue())).map(param -> param.map2(val -> val.getExpression(this.protocol))).map(param -> param.map2(val -> applyEncoding ? ODataUriFactory.encodePathSegment(val) : val)).map(param -> (String)param.apply((key, val) -> String.format("%s=%s", key, val))).collect(Collectors.joining(","));
        keys = String.format("(%s)", keys);
        return keys;
    }

    @Generated
    AbstractPathParameters(@Nonnull ODataProtocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.protocol = protocol;
    }
}

