/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

@Beta
public class ODataRequestAction
extends ODataRequestGeneric {
    @Nonnull
    private final String actionParameters;

    public ODataRequestAction(@Nonnull String servicePath, @Nonnull String actionName, @Nullable String actionParameters, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(actionName), actionParameters, protocol);
    }

    public ODataRequestAction(@Nonnull String servicePath, @Nonnull ODataResourcePath actionPath, @Nullable String actionParameters, @Nonnull ODataProtocol protocol) {
        super(servicePath, actionPath, protocol);
        this.addHeader("Content-Type", "application/json");
        this.actionParameters = actionParameters != null ? actionParameters : "{}";
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), this.getProtocol());
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = new ODataHttpRequest(this, httpClient, this.actionParameters);
        return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPost).get();
    }

    @Nonnull
    @Generated
    public String getActionParameters() {
        return this.actionParameters;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestAction)) {
            return false;
        }
        ODataRequestAction other = (ODataRequestAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$actionParameters = this.getActionParameters();
        String other$actionParameters = other.getActionParameters();
        return !(this$actionParameters == null ? other$actionParameters != null : !this$actionParameters.equals(other$actionParameters));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestAction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $actionParameters = this.getActionParameters();
        result = result * 59 + ($actionParameters == null ? 43 : $actionParameters.hashCode());
        return result;
    }
}

