/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableMap;
import com.sap.cloud.sdk.cloudplatform.connectivity.CsrfToken;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataRequestException;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestAction;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestCreate;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestDelete;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestFunction;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestRead;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestReadByKey;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipartGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestUpdate;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UpdateStrategy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestBatch
extends ODataRequestGeneric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestBatch.class);
    private static final String DEFAULT_ODATA_BATCH_FORMAT_NEWLINE = "\r\n";
    @Nonnull
    private final List<BatchItem> requests = new ArrayList<BatchItem>();
    private final AtomicInteger contentId = new AtomicInteger(1);
    private final UUID batchUuid;
    private final Supplier<UUID> uuidProvider;

    public ODataRequestBatch(@Nonnull String servicePath, @Nonnull ODataProtocol protocol) {
        this(servicePath, protocol, UUID::randomUUID);
    }

    public ODataRequestBatch(@Nonnull String servicePath, @Nonnull ODataProtocol protocol, @Nonnull Supplier<UUID> uuidProvider) {
        super(servicePath, ODataResourcePath.of("$batch"), protocol);
        this.uuidProvider = uuidProvider;
        this.batchUuid = uuidProvider.get();
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), this.getProtocol());
    }

    @Nonnull
    public ODataRequestBatch addRead(@Nonnull ODataRequestRead request) {
        BatchItemSingle item = new BatchItemSingle(this, request, "GET", null);
        this.requests.add(item);
        return this;
    }

    @Nonnull
    public ODataRequestBatch addReadByKey(@Nonnull ODataRequestReadByKey request) {
        BatchItemSingle item = new BatchItemSingle(this, request, "GET", null);
        this.requests.add(item);
        return this;
    }

    @Nonnull
    public ODataRequestBatch addFunction(@Nonnull ODataRequestFunction request) {
        BatchItemSingle item = new BatchItemSingle(this, request, "GET", null);
        this.requests.add(item);
        return this;
    }

    @Nonnull
    public Changeset beginChangeset() {
        return new Changeset(this);
    }

    @Override
    @Nonnull
    public ODataRequestResultMultipartGeneric execute(@Nonnull HttpClient httpClient) {
        if (this.getHeaders().containsKey("x-csrf-token")) {
            log.debug("CSRF token already present, skipping retrieval.");
            return (ODataRequestResultMultipartGeneric)this.tryExecute(httpClient).get();
        }
        Try<CsrfToken> csrfToken = this.tryGetCsrfToken(httpClient);
        csrfToken.onSuccess(token -> this.addHeader("x-csrf-token", token.getToken()));
        Try<ODataRequestResultMultipartGeneric> batchRequest = this.tryExecute(httpClient);
        if (batchRequest.isFailure() && csrfToken.isFailure()) {
            batchRequest.getCause().addSuppressed(csrfToken.getCause());
        }
        return (ODataRequestResultMultipartGeneric)batchRequest.get();
    }

    private Try<ODataRequestResultMultipartGeneric> tryExecute(@Nonnull HttpClient httpClient) {
        String requestBody = this.getBatchRequestBody();
        ODataHttpRequest request = new ODataHttpRequest(this, httpClient, requestBody);
        return Try.of(request::requestPost).map(response -> new ODataRequestResultMultipartGeneric(this, (HttpResponse)response)).andThenTry(ODataHealthyResponseValidator::requireHealthyResponse);
    }

    @Override
    @Nonnull
    protected Map<String, String> getHeaders() {
        Map<String, String> headers = super.getHeaders();
        headers.putAll(this.getBatchHeaders());
        return headers;
    }

    @Nonnull
    private Map<String, String> getBatchHeaders() {
        return ImmutableMap.of((Object)"Content-Type", (Object)("multipart/mixed;boundary=batch_" + this.batchUuid), (Object)"OData-Version", (Object)this.getProtocol().getProtocolVersion());
    }

    @Nonnull
    String getBatchRequestBody() {
        String batchDelimiter = "--batch_" + this.batchUuid;
        String batchDelimiterEnd = batchDelimiter + "--";
        ArrayList<String> resultLines = new ArrayList<String>();
        for (BatchItem item : this.requests) {
            resultLines.add(batchDelimiter);
            resultLines.addAll(item.getLines());
        }
        resultLines.add(batchDelimiterEnd);
        resultLines.add("");
        return String.join((CharSequence)DEFAULT_ODATA_BATCH_FORMAT_NEWLINE, resultLines);
    }

    @Nullable
    static Tuple2<Integer, Integer> getBatchItemPosition(@Nonnull ODataRequestBatch batchRequest, @Nonnull ODataRequestGeneric singleRequest) {
        List<BatchItem> batchItems = batchRequest.getRequests();
        int n = batchItems.size();
        for (int i = 0; i < n; ++i) {
            BatchItem item = batchItems.get(i);
            if (item instanceof BatchItemChangeset) {
                List<BatchItemSingle> nestedRequests = ((BatchItemChangeset)item).getRequests();
                OptionalInt pos = IntStream.range(0, nestedRequests.size()).filter(p -> singleRequest == ((BatchItemSingle)nestedRequests.get(p)).getRequest()).findFirst();
                if (!pos.isPresent()) continue;
                return Tuple.of((Object)i, (Object)pos.getAsInt());
            }
            if (!(item instanceof BatchItemSingle) || singleRequest != ((BatchItemSingle)item).getRequest()) continue;
            return Tuple.of((Object)i, null);
        }
        return null;
    }

    @Nonnull
    @Generated
    public List<BatchItem> getRequests() {
        return this.requests;
    }

    @Generated
    public AtomicInteger getContentId() {
        return this.contentId;
    }

    @Generated
    public UUID getBatchUuid() {
        return this.batchUuid;
    }

    @Generated
    public Supplier<UUID> getUuidProvider() {
        return this.uuidProvider;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestBatch)) {
            return false;
        }
        ODataRequestBatch other = (ODataRequestBatch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<BatchItem> this$requests = this.getRequests();
        List<BatchItem> other$requests = other.getRequests();
        if (this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests)) {
            return false;
        }
        AtomicInteger this$contentId = this.getContentId();
        AtomicInteger other$contentId = other.getContentId();
        if (this$contentId == null ? other$contentId != null : !this$contentId.equals(other$contentId)) {
            return false;
        }
        UUID this$batchUuid = this.getBatchUuid();
        UUID other$batchUuid = other.getBatchUuid();
        if (this$batchUuid == null ? other$batchUuid != null : !((Object)this$batchUuid).equals(other$batchUuid)) {
            return false;
        }
        Supplier<UUID> this$uuidProvider = this.getUuidProvider();
        Supplier<UUID> other$uuidProvider = other.getUuidProvider();
        return !(this$uuidProvider == null ? other$uuidProvider != null : !this$uuidProvider.equals(other$uuidProvider));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestBatch;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<BatchItem> $requests = this.getRequests();
        result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
        AtomicInteger $contentId = this.getContentId();
        result = result * 59 + ($contentId == null ? 43 : $contentId.hashCode());
        UUID $batchUuid = this.getBatchUuid();
        result = result * 59 + ($batchUuid == null ? 43 : ((Object)$batchUuid).hashCode());
        Supplier<UUID> $uuidProvider = this.getUuidProvider();
        result = result * 59 + ($uuidProvider == null ? 43 : $uuidProvider.hashCode());
        return result;
    }

    static interface BatchItem {
        @Nonnull
        public List<String> getLines();
    }

    static final class BatchItemChangeset
    implements BatchItem {
        @Nonnull
        final UUID changeSetId;
        @Nonnull
        final List<BatchItemSingle> requests;

        @Override
        @Nonnull
        public List<String> getLines() {
            String changesetDelimiter = "--changeset_" + this.changeSetId;
            String changesetDelimiterEnd = changesetDelimiter + "--";
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Content-Type: multipart/mixed;boundary=changeset_" + this.changeSetId);
            lines.add("");
            for (BatchItem batchItem : this.requests) {
                lines.add(changesetDelimiter);
                lines.addAll(batchItem.getLines());
            }
            lines.add(changesetDelimiterEnd);
            lines.add("");
            return lines;
        }

        @Generated
        private BatchItemChangeset(@Nonnull UUID changeSetId, @Nonnull List<BatchItemSingle> requests) {
            if (changeSetId == null) {
                throw new NullPointerException("changeSetId is marked non-null but is null");
            }
            if (requests == null) {
                throw new NullPointerException("requests is marked non-null but is null");
            }
            this.changeSetId = changeSetId;
            this.requests = requests;
        }

        @Nonnull
        @Generated
        public UUID getChangeSetId() {
            return this.changeSetId;
        }

        @Nonnull
        @Generated
        public List<BatchItemSingle> getRequests() {
            return this.requests;
        }
    }

    static final class BatchItemSingle
    implements BatchItem {
        private final int contentId;
        @Nonnull
        final ODataRequestGeneric request;
        @Nonnull
        private final String resourcePath;
        @Nonnull
        private final String httpMethod;
        @Nullable
        private final Supplier<String> payload;

        private BatchItemSingle(@Nonnull ODataRequestBatch requestBatch, @Nonnull ODataRequestGeneric request, @Nonnull String httpMethod, @Nullable Supplier<String> payload) {
            String resourceWithServicePath = request.getRelativeUri().toString();
            String servicePath = StringUtils.appendIfMissing((String)requestBatch.getServicePath(), (CharSequence)"/", (CharSequence[])new CharSequence[0]);
            if (!resourceWithServicePath.startsWith(servicePath)) {
                throw new ODataRequestException(requestBatch, "Batch request contains requests to different service path,", null);
            }
            if (!Objects.equals(request.getProtocol(), requestBatch.getProtocol())) {
                throw new ODataRequestException(requestBatch, "Batch request contains requests with different protocol versions,", null);
            }
            this.contentId = requestBatch.contentId.getAndIncrement();
            this.request = request;
            this.resourcePath = resourceWithServicePath.substring(servicePath.length());
            this.httpMethod = httpMethod;
            this.payload = payload;
        }

        @Override
        @Nonnull
        public List<String> getLines() {
            ArrayList<String> lines = new ArrayList<String>();
            lines.add("Content-Type: application/http");
            lines.add("Content-Transfer-Encoding: binary");
            lines.add("Content-ID: " + this.contentId);
            lines.add("");
            lines.add(String.format("%s %s HTTP/1.1", this.httpMethod, this.resourcePath));
            this.request.getHeaders().forEach((k, v) -> lines.add(k + ": " + v));
            lines.add("");
            if (this.payload != null) {
                lines.add(this.payload.get());
            }
            lines.add("");
            return lines;
        }

        @Generated
        public int getContentId() {
            return this.contentId;
        }

        @Nonnull
        @Generated
        public ODataRequestGeneric getRequest() {
            return this.request;
        }

        @Nonnull
        @Generated
        public String getResourcePath() {
            return this.resourcePath;
        }

        @Nonnull
        @Generated
        public String getHttpMethod() {
            return this.httpMethod;
        }

        @Nullable
        @Generated
        public Supplier<String> getPayload() {
            return this.payload;
        }
    }

    @Beta
    public static final class Changeset {
        private final ODataRequestBatch originalRequest;
        private final List<BatchItemSingle> queries = new ArrayList<BatchItemSingle>();

        @Nonnull
        public Changeset addCreate(@Nonnull ODataRequestCreate request) {
            BatchItemSingle item = new BatchItemSingle(this.originalRequest, request, "POST", request::getSerializedEntity);
            this.queries.add(item);
            return this;
        }

        @Nonnull
        public Changeset addUpdate(@Nonnull ODataRequestUpdate request) {
            String versionIdentifier = request.getVersionIdentifier();
            request.addVersionIdentifierToHeaderIfPresent(versionIdentifier);
            String httpMethod = request.getUpdateStrategy() == UpdateStrategy.MODIFY_WITH_PATCH ? "PATCH" : "PUT";
            BatchItemSingle item = new BatchItemSingle(this.originalRequest, request, httpMethod, request::getSerializedEntity);
            this.queries.add(item);
            return this;
        }

        @Nonnull
        public Changeset addDelete(@Nonnull ODataRequestDelete request) {
            String versionIdentifier = request.getVersionIdentifier();
            request.addVersionIdentifierToHeaderIfPresent(versionIdentifier);
            BatchItemSingle item = new BatchItemSingle(this.originalRequest, request, "DELETE", null);
            this.queries.add(item);
            return this;
        }

        @Nonnull
        public Changeset addAction(@Nonnull ODataRequestAction request) {
            BatchItemSingle item = new BatchItemSingle(this.originalRequest, request, "POST", request::getActionParameters);
            this.queries.add(item);
            return this;
        }

        @Nonnull
        public ODataRequestBatch endChangeset() {
            UUID changeSetId = (UUID)this.originalRequest.uuidProvider.get();
            BatchItemChangeset item = new BatchItemChangeset(changeSetId, this.queries);
            this.originalRequest.requests.add(item);
            return this.originalRequest;
        }

        @Generated
        private Changeset(ODataRequestBatch originalRequest) {
            this.originalRequest = originalRequest;
        }
    }
}

