/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestDelete
extends ODataRequestGeneric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestDelete.class);
    @Nullable
    private final String versionIdentifier;

    public ODataRequestDelete(@Nonnull String servicePath, @Nonnull String entityName, @Nonnull ODataEntityKey entityKey, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(entityName, entityKey), versionIdentifier, protocol);
    }

    public ODataRequestDelete(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        super(servicePath, entityPath, protocol);
        this.addHeader("Accept", "application/json");
        this.versionIdentifier = versionIdentifier;
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), this.getProtocol());
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = new ODataHttpRequest(this, httpClient);
        this.addVersionIdentifierToHeaderIfPresent(this.versionIdentifier);
        return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestDelete).get();
    }

    @Nullable
    @Generated
    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestDelete)) {
            return false;
        }
        ODataRequestDelete other = (ODataRequestDelete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$versionIdentifier = this.getVersionIdentifier();
        String other$versionIdentifier = other.getVersionIdentifier();
        return !(this$versionIdentifier == null ? other$versionIdentifier != null : !this$versionIdentifier.equals(other$versionIdentifier));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestDelete;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $versionIdentifier = this.getVersionIdentifier();
        result = result * 59 + ($versionIdentifier == null ? 43 : $versionIdentifier.hashCode());
        return result;
    }
}

