/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataFunctionParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

@Beta
public class ODataRequestFunction
extends ODataRequestGeneric {
    @Nonnull
    private final String query;

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull String functionName, @Nonnull ODataFunctionParameters parameters, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(functionName, parameters), null, protocol);
    }

    public ODataRequestFunction(@Nonnull String servicePath, @Nonnull ODataResourcePath functionPath, @Nullable String encodedQuery, @Nonnull ODataProtocol protocol) {
        super(servicePath, functionPath, protocol);
        this.query = encodedQuery != null ? encodedQuery : "";
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), this.getProtocol());
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = new ODataHttpRequest(this, httpClient);
        return (ODataRequestResultGeneric)this.tryExecute(request::requestGet, httpClient).get();
    }

    @Override
    @Nonnull
    public String getRequestQuery() {
        String genericQueryString = super.getRequestQuery();
        if (!genericQueryString.isEmpty() && !this.query.isEmpty()) {
            return this.query + "&" + genericQueryString;
        }
        return this.query + genericQueryString;
    }

    @Nonnull
    @Generated
    public String getQuery() {
        return this.query;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestFunction)) {
            return false;
        }
        ODataRequestFunction other = (ODataRequestFunction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        return !(this$query == null ? other$query != null : !this$query.equals(other$query));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestFunction;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        return result;
    }
}

