/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.google.common.collect.Iterables;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestBatch;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipart;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipartParser;
import io.vavr.CheckedFunction0;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestResultMultipartGeneric
implements ODataRequestResultMultipart,
ODataRequestResult {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultMultipartGeneric.class);
    private static final String HEADER_VALUE_DELIMITER = ";";
    private static final String MSG_ON_FAILURE = "Failed to read response entity from OData request result. Please make sure the entity is not consumed already by the application.";
    @Nonnull
    private final ODataRequestBatch batchRequest;
    @Nonnull
    private final HttpResponse httpResponse;
    @Nullable
    private final AtomicReference<Object> batchContent = new AtomicReference();

    ODataRequestResultMultipartGeneric(@Nonnull ODataRequestBatch oDataRequest, @Nonnull HttpResponse httpResponse) {
        this.batchRequest = oDataRequest;
        this.httpResponse = httpResponse;
    }

    @Nonnull
    private Map<String, Iterable<String>> getResponseHeaders() {
        return Arrays.stream(this.getHttpResponse().getAllHeaders()).collect(Collectors.toMap(header -> header.getName().toLowerCase(), header -> Arrays.asList(header.getValue().split("\\W*;\\W*")), Iterables::concat));
    }

    @Override
    @Nonnull
    public Iterable<String> getHeaderValues(@Nonnull String headerName) {
        return this.getResponseHeaders().getOrDefault(headerName.toLowerCase(), Collections.emptyList());
    }

    @Override
    @Nonnull
    public Iterable<String> getHeaderNames() {
        return this.getResponseHeaders().keySet();
    }

    @Override
    @Nonnull
    public ODataRequestBatch getODataRequest() {
        return this.batchRequest;
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric getResult(@Nonnull ODataRequestGeneric request) throws ODataResponseException, IllegalArgumentException {
        HttpResponse response;
        Tuple2<Integer, Integer> responsePosition = ODataRequestBatch.getBatchItemPosition(this.batchRequest, request);
        if (responsePosition == null) {
            throw new IllegalArgumentException("Incorrect API usage. Please pass the original OData request reference that was handled as batch request item.");
        }
        String content = this.getBatchContent();
        if (content == null) {
            String msg = "OData batch response did not contain an HTTP body.";
            throw new ODataResponseException(this.batchRequest, this.httpResponse, "OData batch response did not contain an HTTP body.", null);
        }
        Iterable<String> contentType = this.getHeaderValues("Content-Type");
        ODataRequestResultMultipartParser parser = new ODataRequestResultMultipartParser(content, contentType);
        log.debug("Looking for request {} in batch response at position {}", (Object)request, responsePosition);
        HttpResponse httpResponse = response = responsePosition._2() == null ? parser.extractHttpResponseForReceiving((Integer)responsePosition._1()) : parser.extractHttpResponseForModifying((Integer)responsePosition._1(), (Integer)responsePosition._2());
        if (response == null) {
            String msg = "Illegal payload for OData batch response item.";
            throw new ODataDeserializationException(this.batchRequest, this.httpResponse, "Illegal payload for OData batch response item.", null);
        }
        return new ODataRequestResultGeneric(request, response);
    }

    @Nullable
    private String readAndConsumeResponseContent() {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> EntityUtils.toString((HttpEntity)this.httpResponse.getEntity())).onFailure(e -> log.error(MSG_ON_FAILURE, e)).getOrNull();
    }

    @Override
    @Nonnull
    @Generated
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @Generated
    private String getBatchContent() {
        Object value = this.batchContent.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.batchContent;
            synchronized (atomicReference) {
                value = this.batchContent.get();
                if (value == null) {
                    String actualValue = this.readAndConsumeResponseContent();
                    value = actualValue == null ? this.batchContent : actualValue;
                    this.batchContent.set(value);
                }
            }
        }
        return (String)(value == this.batchContent ? null : value);
    }
}

