/*
 * Copyright (c) 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.expression;

import static com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions.createOperand;

import javax.annotation.Nonnull;

import com.google.common.annotations.Beta;

/**
 * Logical operations for generic OData filter expression operands.
 */
@Beta
public interface FilterableComparisonAbsolute extends Expressions.Operand
{
    /**
     * Filter by expression "eq".
     *
     * @param operand
     *            The generic operand to compare with.
     * @return The FluentHelper filter.
     */
    @Nonnull
    default ValueBoolean equalTo( @Nonnull final Expressions.Operand operand )
    {
        return FilterExpressionLogical.equalTo(this, operand);
    }

    /**
     * Filter by expression "eq".
     *
     * @param operand
     *            The generic object to compare with.
     * @return The FluentHelper filter.
     * @throws IllegalArgumentException
     *             When there is no mapping found for the provided Java literal.
     */
    @Nonnull
    default ValueBoolean equalTo( @Nonnull final Object operand )
    {
        final Expressions.Operand value = createOperand(operand);
        return equalTo(value);
    }

    /**
     * Filter by expression "ne".
     *
     * @param operand
     *            The generic operand to compare with.
     * @return The FluentHelper filter.
     */
    @Nonnull
    default ValueBoolean notEqualTo( @Nonnull final Expressions.Operand operand )
    {
        return FilterExpressionLogical.notEqualTo(this, operand);
    }

    /**
     * Filter by expression "ne".
     *
     * @param operand
     *            The generic object to compare with.
     * @return The FluentHelper filter.
     * @throws IllegalArgumentException
     *             When there is no mapping found for the provided Java literal.
     */
    @Nonnull
    default ValueBoolean notEqualTo( @Nonnull final Object operand )
    {
        final Expressions.Operand value = createOperand(operand);
        return notEqualTo(value);
    }
}
