/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataRequestException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultPagination;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class ODataRequestResultPaginationIterator
implements Iterator<ODataRequestResultPagination> {
    @Nullable
    private Supplier<ODataRequestResultPagination> nextPageLazy = () -> firstPage;

    ODataRequestResultPaginationIterator(@Nonnull ODataRequestResultPagination firstPage) {
    }

    @Override
    public boolean hasNext() {
        return this.nextPageLazy != null;
    }

    @Override
    @Nonnull
    public ODataRequestResultPagination next() throws NoSuchElementException, ODataException {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next page of OData result-set defined.");
        }
        ODataRequestResultPagination page = Objects.requireNonNull(this.nextPageLazy).get();
        this.nextPageLazy = page.getNextLink().isDefined() ? () -> this.requestNextPage(page) : null;
        return page;
    }

    @Nonnull
    protected ODataRequestResultPagination requestNextPage(@Nonnull ODataRequestResultPagination page) {
        return (ODataRequestResultPagination)page.tryGetNextPage().andThenTry(ODataHealthyResponseValidator::requireHealthyResponse).getOrElseThrow(e -> new ODataRequestException(page.getODataRequest(), "Failed to handle next page.", (Throwable)e));
    }
}

