/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.base.Charsets;
import com.google.common.base.Strings;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataConnectionException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ODataHttpRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataHttpRequest.class);
    @Nonnull
    private final ODataRequestGeneric odataRequest;
    @Nonnull
    private final HttpClient httpClient;
    @Nullable
    private String requestBody;

    @Nonnull
    private HttpResponse requestResource(@Nonnull Function<URI, HttpRequestBase> requestCreator) {
        HttpRequestBase httpRequest = requestCreator.apply(this.getUri());
        this.odataRequest.getHeaders().forEach((arg_0, arg_1) -> ((HttpRequestBase)httpRequest).setHeader(arg_0, arg_1));
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            if (!Strings.isNullOrEmpty((String)this.requestBody)) {
                StringEntity entity = new StringEntity(this.requestBody, Charsets.UTF_8);
                ((HttpEntityEnclosingRequest)httpRequest).setEntity((HttpEntity)entity);
            } else {
                log.warn("The HTTP request {} was expecting an entity, but none was provided.", (Object)httpRequest);
            }
        }
        this.odataRequest.getListeners().forEach(v -> v.listenOnRequest(httpRequest));
        try {
            return this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            log.debug("Connection could not be established.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection could not be established.", e);
        }
        catch (IOException e) {
            log.debug("Connection was aborted.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection was aborted.", e);
        }
        catch (Exception e) {
            log.debug("Connection failed.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection failed.", e);
        }
    }

    @Nonnull
    HttpResponse requestGet() {
        return this.requestResource(HttpGet::new);
    }

    @Nonnull
    HttpResponse requestPost() {
        return this.requestResource(HttpPost::new);
    }

    @Nonnull
    HttpResponse requestPatch() {
        return this.requestResource(HttpPatch::new);
    }

    @Nonnull
    HttpResponse requestPut() {
        return this.requestResource(HttpPut::new);
    }

    @Nonnull
    HttpResponse requestDelete() {
        return this.requestResource(HttpDelete::new);
    }

    private URI getUri() {
        return this.odataRequest.getRelativeUri();
    }

    @Generated
    public ODataHttpRequest(@Nonnull ODataRequestGeneric odataRequest, @Nonnull HttpClient httpClient) {
        if (odataRequest == null) {
            throw new NullPointerException("odataRequest is marked non-null but is null");
        }
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        this.odataRequest = odataRequest;
        this.httpClient = httpClient;
    }

    @Generated
    public ODataHttpRequest(@Nonnull ODataRequestGeneric odataRequest, @Nonnull HttpClient httpClient, @Nullable String requestBody) {
        if (odataRequest == null) {
            throw new NullPointerException("odataRequest is marked non-null but is null");
        }
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        this.odataRequest = odataRequest;
        this.httpClient = httpClient;
        this.requestBody = requestBody;
    }
}

