/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UpdateStrategy;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestUpdate
extends ODataRequestGeneric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestUpdate.class);
    @Nonnull
    private final String serializedEntity;
    @Nonnull
    private UpdateStrategy updateStrategy;
    @Nullable
    private final String versionIdentifier;

    public ODataRequestUpdate(@Nonnull String servicePath, @Nonnull String entityName, @Nonnull ODataEntityKey entityKey, @Nonnull String serializedEntity, @Nonnull UpdateStrategy updateStrategy, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(entityName, entityKey), serializedEntity, updateStrategy, versionIdentifier, protocol);
    }

    public ODataRequestUpdate(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nonnull String serializedEntity, @Nonnull UpdateStrategy updateStrategy, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        super(servicePath, entityPath, protocol);
        this.addHeader("Accept", "application/json");
        this.addHeader("Content-Type", "application/json");
        this.serializedEntity = serializedEntity;
        this.updateStrategy = updateStrategy;
        this.versionIdentifier = versionIdentifier;
    }

    @Override
    @Nonnull
    public URI getRelativeUri() {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery());
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = new ODataHttpRequest(this, httpClient, this.serializedEntity);
        this.addVersionIdentifierToHeaderIfPresent(this.versionIdentifier);
        if (this.updateStrategy == UpdateStrategy.MODIFY_WITH_PATCH) {
            return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPatch).get();
        }
        if (this.updateStrategy == UpdateStrategy.REPLACE_WITH_PUT) {
            return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPut).get();
        }
        throw new IllegalStateException("Unexpected update Strategy: " + (Object)((Object)this.updateStrategy));
    }

    @Nonnull
    @Generated
    public String getSerializedEntity() {
        return this.serializedEntity;
    }

    @Nonnull
    @Generated
    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    @Nullable
    @Generated
    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestUpdate)) {
            return false;
        }
        ODataRequestUpdate other = (ODataRequestUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$serializedEntity = this.getSerializedEntity();
        String other$serializedEntity = other.getSerializedEntity();
        if (this$serializedEntity == null ? other$serializedEntity != null : !this$serializedEntity.equals(other$serializedEntity)) {
            return false;
        }
        UpdateStrategy this$updateStrategy = this.getUpdateStrategy();
        UpdateStrategy other$updateStrategy = other.getUpdateStrategy();
        if (this$updateStrategy == null ? other$updateStrategy != null : !((Object)((Object)this$updateStrategy)).equals((Object)other$updateStrategy)) {
            return false;
        }
        String this$versionIdentifier = this.getVersionIdentifier();
        String other$versionIdentifier = other.getVersionIdentifier();
        return !(this$versionIdentifier == null ? other$versionIdentifier != null : !this$versionIdentifier.equals(other$versionIdentifier));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestUpdate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $serializedEntity = this.getSerializedEntity();
        result = result * 59 + ($serializedEntity == null ? 43 : $serializedEntity.hashCode());
        UpdateStrategy $updateStrategy = this.getUpdateStrategy();
        result = result * 59 + ($updateStrategy == null ? 43 : ((Object)((Object)$updateStrategy)).hashCode());
        String $versionIdentifier = this.getVersionIdentifier();
        result = result * 59 + ($versionIdentifier == null ? 43 : $versionIdentifier.hashCode());
        return result;
    }

    @Generated
    public void setUpdateStrategy(@Nonnull UpdateStrategy updateStrategy) {
        if (updateStrategy == null) {
            throw new NullPointerException("updateStrategy is marked non-null but is null");
        }
        this.updateStrategy = updateStrategy;
    }
}

