/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.google.common.base.Strings;
import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.sap.cloud.sdk.datamodel.odata.client.JsonPath;
import com.sap.cloud.sdk.datamodel.odata.client.ODataResponseDeserializer;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataRequestException;
import com.sap.cloud.sdk.datamodel.odata.client.request.HttpEntityReader;
import com.sap.cloud.sdk.datamodel.odata.client.request.NumberDeserializationStrategy;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataGsonBuilder;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestRead;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultDeserializable;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultPagination;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.ResultCollection;
import com.sap.cloud.sdk.result.ResultElement;
import com.sap.cloud.sdk.result.ResultObject;
import com.sap.cloud.sdk.result.ResultPrimitive;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.ClassUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestResultGeneric
implements ODataRequestResult,
ODataRequestResultDeserializable,
ODataRequestResultPagination {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultGeneric.class);
    private final ODataResponseDeserializer deserializer;
    @Nullable
    private volatile HttpResponse bufferedHttpResponse;
    private volatile boolean isBufferHttpResponse = true;
    @Nonnull
    private final ODataRequestGeneric oDataRequest;
    @Nonnull
    private final HttpResponse httpResponse;
    private NumberDeserializationStrategy numberStrategy = NumberDeserializationStrategy.DOUBLE;
    @Nullable
    private final transient HttpClient httpClient;

    public ODataRequestResultGeneric(@Nonnull ODataRequestGeneric oDataRequest, @Nonnull HttpResponse httpResponse) {
        this(oDataRequest, httpResponse, null);
    }

    public ODataRequestResultGeneric(@Nonnull ODataRequestGeneric oDataRequest, @Nonnull HttpResponse httpResponse, @Nullable HttpClient httpClient) {
        this.oDataRequest = oDataRequest;
        this.httpResponse = httpResponse;
        this.httpClient = httpClient;
        this.deserializer = new ODataResponseDeserializer(oDataRequest.getProtocol());
    }

    @Nonnull
    public ODataRequestResultGeneric withNumberDeserializationStrategy(@Nonnull NumberDeserializationStrategy numberStrategy) {
        this.numberStrategy = numberStrategy;
        return this;
    }

    public void disableBufferingHttpResponse() {
        if (this.bufferedHttpResponse == null) {
            this.isBufferHttpResponse = false;
        } else {
            log.warn("Buffering the HTTP response cannot be disabled! The content has already been buffered.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public HttpResponse getHttpResponse() {
        if (!this.isBufferHttpResponse) {
            log.debug("Buffering is disabled, returning unbuffered http response");
            return this.httpResponse;
        }
        if (this.bufferedHttpResponse != null) {
            return Objects.requireNonNull(this.bufferedHttpResponse);
        }
        ODataRequestResultGeneric oDataRequestResultGeneric = this;
        synchronized (oDataRequestResultGeneric) {
            if (this.bufferedHttpResponse != null) {
                return Objects.requireNonNull(this.bufferedHttpResponse);
            }
            StatusLine statusLine = this.httpResponse.getStatusLine();
            HttpEntity httpEntity = this.httpResponse.getEntity();
            if (statusLine == null || httpEntity == null) {
                log.debug("skipping buffering of http entity as either there is no http entity or response does not include a status-line.");
                return this.httpResponse;
            }
            Try entity = Try.of((CheckedFunction0 & Serializable)() -> new BufferedHttpEntity(httpEntity));
            if (entity.isFailure()) {
                log.warn("Failed to buffer HTTP response. Unable to buffer HTTP entity.", entity.getCause());
                return this.httpResponse;
            }
            BasicHttpResponse proxyResponse = new BasicHttpResponse(statusLine);
            proxyResponse.setHeaders(this.httpResponse.getAllHeaders());
            proxyResponse.setEntity((HttpEntity)entity.get());
            Option.of((Object)this.httpResponse.getLocale()).peek(arg_0 -> ((BasicHttpResponse)proxyResponse).setLocale(arg_0));
            this.bufferedHttpResponse = proxyResponse;
        }
        return Objects.requireNonNull(this.bufferedHttpResponse);
    }

    @Override
    public void streamElements(@Nonnull Consumer<ResultElement> handler) {
        GsonResultElementFactory resultElementFactory = this.getResultElementFactory();
        Integer numConsumedElements = (Integer)HttpEntityReader.stream(this, (CheckedFunction1 & Serializable)reader -> {
            this.deserializer.positionReaderToResultSet((JsonReader)reader);
            int count = 0;
            while (reader.hasNext() && reader.peek() == JsonToken.BEGIN_OBJECT) {
                JsonElement jsonElement = JsonParser.parseReader((JsonReader)reader);
                ResultElement resultElement = resultElementFactory.create(jsonElement);
                handler.accept(resultElement);
                ++count;
            }
            reader.close();
            return count;
        });
        log.debug("Iterated {} elements.", (Object)numConsumedElements);
    }

    private GsonResultElementFactory getResultElementFactory() {
        GsonBuilder gsonBuilder = ODataGsonBuilder.newGsonBuilder(this.numberStrategy);
        return new GsonResultElementFactory(gsonBuilder);
    }

    @Nonnull
    public Option<String> getVersionIdentifierFromHeader() {
        return Option.ofOptional(Stream.of(this.getHttpResponse().getHeaders("ETag")).filter(h -> "ETag".equalsIgnoreCase(h.getName())).map(NameValuePair::getValue).filter(s -> !Strings.isNullOrEmpty((String)s)).findFirst());
    }

    @Nonnull
    private ResultPrimitive loadPrimitiveFromResponse(@Nonnull Function<JsonElement, JsonElement> jsonElementExtractor) {
        GsonResultElementFactory elementFactory = this.getResultElementFactory();
        ResultPrimitive result = (ResultPrimitive)HttpEntityReader.read(this, (CheckedFunction1 & Serializable)element -> {
            Option single = this.deserializer.getElementToResultPrimitiveSingle((JsonElement)element).map(jsonElementExtractor).map(arg_0 -> ((GsonResultElementFactory)elementFactory).create(arg_0)).map(ResultElement::getAsPrimitive);
            return (ResultPrimitive)single.getOrNull();
        });
        if (result == null) {
            log.debug("OData response cannot be read as a primitive value.");
            throw new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "Unable to read OData response.", null);
        }
        return result;
    }

    @Nonnull
    private ResultCollection loadPrimitiveCollectionFromResponse() {
        GsonResultElementFactory elementFactory = this.getResultElementFactory();
        ResultCollection result = (ResultCollection)HttpEntityReader.read(this, (CheckedFunction1 & Serializable)element -> {
            Option set = this.deserializer.getElementToResultPrimitiveSet((JsonElement)element).map(arg_0 -> ((GsonResultElementFactory)elementFactory).create(arg_0)).map(ResultElement::getAsCollection);
            return (ResultCollection)set.getOrNull();
        });
        if (result == null) {
            log.debug("OData response cannot be read as set of primitive values.");
            throw new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "Unable to read OData response.", null);
        }
        return result;
    }

    @Nonnull
    private ResultObject loadEntryFromResponse(@Nonnull Function<JsonElement, JsonElement> jsonElementExtractor) {
        GsonResultElementFactory elementFactory = this.getResultElementFactory();
        ResultObject result = (ResultObject)HttpEntityReader.read(this, (CheckedFunction1 & Serializable)element -> {
            Option single = this.deserializer.getElementToResultSingle((JsonElement)element).map(jsonElementExtractor).map(arg_0 -> ((GsonResultElementFactory)elementFactory).create(arg_0)).map(ResultElement::getAsObject);
            return (ResultObject)single.getOrNull();
        });
        if (result == null) {
            log.debug("OData response cannot be read as a single entity.");
            throw new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "Unable to read OData response.", null);
        }
        return result;
    }

    @Nonnull
    private ResultCollection loadEntryCollectionFromResponse() {
        GsonResultElementFactory elementFactory = this.getResultElementFactory();
        ResultCollection result = (ResultCollection)HttpEntityReader.read(this, (CheckedFunction1 & Serializable)element -> {
            Option set = this.deserializer.getElementToResultSet((JsonElement)element).map(arg_0 -> ((GsonResultElementFactory)elementFactory).create(arg_0)).map(ResultElement::getAsCollection);
            return (ResultCollection)set.getOrNull();
        });
        if (result == null) {
            log.debug("OData response cannot be read as set of entities.");
            throw new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "Unable to read OData response.", null);
        }
        return result;
    }

    @Nonnull
    private ResultElement getResultElement() {
        return this.loadEntryFromResponse(Function.identity());
    }

    @Nonnull
    Iterable<ResultElement> getResultElements() {
        return this.loadEntryCollectionFromResponse();
    }

    @Override
    @Nonnull
    public Iterator<ResultElement> iterator() {
        this.assertNonEmptyPayload();
        return this.getResultElements().iterator();
    }

    @Override
    @Nonnull
    public <T> T as(@Nonnull Class<T> objectType) {
        return this.as(objectType, Function.identity());
    }

    @Nonnull
    public <T> T as(@Nonnull Class<T> objectType, @Nonnull Function<JsonElement, JsonElement> resultExtractor) {
        this.assertNonEmptyPayload();
        this.assertResultTypeIsNotVoid(objectType);
        if (this.isPrimitiveOrWrapperOrString(objectType)) {
            ContentType contentType = ContentType.get((HttpEntity)this.getHttpResponse().getEntity());
            if (contentType != null && Objects.equals(contentType.getMimeType(), ContentType.TEXT_PLAIN.getMimeType())) {
                return this.getPrimitiveObjectFromPlainText(objectType);
            }
            return this.getPrimitiveObjectFromJson(objectType, resultExtractor);
        }
        return this.getComplexObjectFromJson(objectType, resultExtractor);
    }

    @Nonnull
    private <T> T getComplexObjectFromJson(@Nonnull Class<T> objectType, @Nonnull Function<JsonElement, JsonElement> resultExtractor) {
        ResultObject resultObject = this.loadEntryFromResponse(resultExtractor);
        ODataRequestGeneric r = this.getODataRequest();
        return (T)Try.of((CheckedFunction0 & Serializable)() -> resultObject.as(objectType)).onFailure(e -> log.debug("Failed to deserialize {} from JSON response.", (Object)objectType)).getOrElseThrow(e -> new ODataDeserializationException(r, this.getHttpResponse(), "Failed to deserialize a complex object.", (Throwable)e));
    }

    @Nonnull
    private <T> T getPrimitiveObjectFromJson(@Nonnull Class<T> objectType, @Nonnull Function<JsonElement, JsonElement> resultExtractor) {
        ResultPrimitive resultPrimitive = this.loadPrimitiveFromResponse(resultExtractor);
        ODataRequestGeneric r = this.getODataRequest();
        return (T)Try.of((CheckedFunction0 & Serializable)() -> this.getPrimitiveAsType(resultPrimitive, objectType)).onFailure(e -> log.debug("Failed to deserialize {} from JSON response.", (Object)objectType)).getOrElseThrow(e -> new ODataDeserializationException(r, this.getHttpResponse(), "Failed to deserialize a primitive object.", (Throwable)e));
    }

    @Nonnull
    private <T> T getPrimitiveObjectFromPlainText(@Nonnull Class<T> objectType) throws ODataDeserializationException {
        ODataRequestGeneric r = this.getODataRequest();
        HttpResponse httpResponse = this.getHttpResponse();
        String objectText = (String)Try.of((CheckedFunction0 & Serializable)() -> EntityUtils.toString((HttpEntity)this.getHttpResponse().getEntity(), (Charset)StandardCharsets.UTF_8)).getOrElseThrow(e -> new ODataDeserializationException(r, httpResponse, "Failed to parse HTTP response.", (Throwable)e));
        return (T)Try.of((CheckedFunction0 & Serializable)() -> new Gson().fromJson(objectText, objectType)).filterTry(Objects::nonNull, () -> new ODataDeserializationException(r, httpResponse, "The response is null.", null)).onFailure(e -> log.debug("Failed to deserialize {} from text/plain response: {}", (Object)objectType, (Object)objectText)).getOrElseThrow(e -> new ODataDeserializationException(r, httpResponse, "Failed to deserialize a primitive object.", (Throwable)e));
    }

    private boolean isPrimitiveOrWrapperOrString(@Nonnull Class<?> objectType) {
        return ClassUtils.isPrimitiveOrWrapper(objectType) || objectType == String.class;
    }

    @Nonnull
    private <T> T as(@Nonnull Type objectType) {
        Class typeClass = objectType instanceof ParameterizedType ? (Class)((ParameterizedType)objectType).getRawType() : objectType.getClass();
        return this.as(typeClass);
    }

    @Override
    @Nonnull
    public <T> List<T> asList(@Nonnull Class<T> objectType) {
        this.assertNonEmptyPayload();
        this.assertResultTypeIsNotVoid(objectType);
        ResultCollection result = this.isPrimitiveOrWrapperOrString(objectType) ? this.loadPrimitiveCollectionFromResponse() : this.loadEntryCollectionFromResponse();
        return (List)Try.of((CheckedFunction0 & Serializable)() -> result.asList(objectType)).onFailure(e -> log.debug("Failed to parse OData result to a list of {}", (Object)objectType)).getOrElseThrow(e -> new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "Failed to parse OData result to a list.", (Throwable)e));
    }

    @Nonnull
    private <T> List<T> asList(@Nonnull Type objectType) {
        Class typeClass = objectType instanceof ParameterizedType ? (Class)((ParameterizedType)objectType).getRawType() : objectType.getClass();
        return this.asList(typeClass);
    }

    @Override
    public long getInlineCount() {
        this.assertNonEmptyPayload();
        for (JsonPath path : this.getODataRequest().getProtocol().getPathToInlineCount().getPaths()) {
            ResultElement resultElement = this.getResultElement(path);
            if (resultElement == null) continue;
            return resultElement.getAsPrimitive().asLong();
        }
        String message = "Inline count not found in OData response payload.";
        throw new ODataDeserializationException(this.oDataRequest, this.getHttpResponse(), "Inline count not found in OData response payload.", null);
    }

    @Override
    @Nonnull
    public Option<String> getNextLink() {
        log.debug("Checking for a next link on current page.");
        this.assertNonEmptyPayload();
        for (JsonPath path : this.getODataRequest().getProtocol().getPathToNextLink().getPaths()) {
            ResultElement resultElement = this.getResultElement(path);
            if (resultElement == null) continue;
            return Option.of((Object)resultElement).map(ResultElement::asString).peek(link -> log.debug("Found reference to next page: {}", link));
        }
        log.debug("Result does not reference any further pages.");
        return Option.none();
    }

    @Nullable
    private ResultElement getResultElement(@Nonnull JsonPath path) {
        ResultElement resultElement = this.getResultElement();
        List<String> nodes = path.getNodes();
        for (int i = 0; i < nodes.size() && resultElement != null && resultElement.isResultObject(); ++i) {
            resultElement = resultElement.getAsObject().get(nodes.get(i));
        }
        return resultElement;
    }

    @Override
    @Nonnull
    public Map<String, Object> asMap() {
        this.assertNonEmptyPayload();
        Type type = new TypeToken<Map<String, Object>>(){
            private static final long serialVersionUID = 42L;
        }.getType();
        return (Map)this.as(type);
    }

    @Override
    @Nonnull
    public List<Map<String, Object>> asListOfMaps() {
        this.assertNonEmptyPayload();
        Type type = new TypeToken<Map<String, Object>>(){
            private static final long serialVersionUID = 42L;
        }.getType();
        return this.asList(type);
    }

    @Nonnull
    private <T> T getPrimitiveAsType(@Nonnull ResultPrimitive primitive, @Nonnull Class<T> type) throws IllegalArgumentException {
        Object primitiveAsType;
        block13: {
            try {
                if (type == Boolean.class) {
                    primitiveAsType = primitive.asBoolean();
                    break block13;
                }
                if (type == Byte.class) {
                    primitiveAsType = primitive.asByte();
                    break block13;
                }
                if (type == Short.class) {
                    primitiveAsType = primitive.asShort();
                    break block13;
                }
                if (type == Integer.class) {
                    primitiveAsType = primitive.asInteger();
                    break block13;
                }
                if (type == Long.class) {
                    primitiveAsType = primitive.asLong();
                    break block13;
                }
                if (type == BigInteger.class) {
                    primitiveAsType = primitive.asBigInteger();
                    break block13;
                }
                if (type == Float.class) {
                    primitiveAsType = Float.valueOf(primitive.asFloat());
                    break block13;
                }
                if (type == Double.class) {
                    primitiveAsType = primitive.asDouble();
                    break block13;
                }
                if (type == BigDecimal.class) {
                    primitiveAsType = primitive.asBigDecimal();
                    break block13;
                }
                if (type == Character.class) {
                    primitiveAsType = Character.valueOf(primitive.asCharacter());
                    break block13;
                }
                if (type == String.class) {
                    primitiveAsType = primitive.asString();
                    break block13;
                }
                throw new IllegalArgumentException("Failed to convert primitive '" + primitive.asString() + "' to unsupported type: " + type.getName() + ".");
            }
            catch (UnsupportedOperationException e) {
                throw new IllegalArgumentException("Failed to convert primitive '" + primitive.asString() + "' to type: " + type.getName() + ".", e);
            }
        }
        Boolean result = primitiveAsType;
        return (T)result;
    }

    @Override
    @Nonnull
    public Try<ODataRequestResultGeneric> tryGetNextPage() {
        ODataRequestGeneric rawRequest = this.getODataRequest();
        if (!(rawRequest instanceof ODataRequestRead)) {
            return Try.failure((Throwable)new IllegalStateException("Pagination is only applicable for read requests."));
        }
        ODataRequestRead request = (ODataRequestRead)rawRequest;
        HttpClient httpClient = this.getHttpClient();
        if (httpClient == null) {
            String message = "Unable to access response of next page: HTTP client was not provided when creating this response object.";
            return Try.failure((Throwable)new ODataRequestException(request, "Unable to access response of next page: HTTP client was not provided when creating this response object.", null));
        }
        Try nextQuery = this.getNextLink().toTry(() -> new IllegalStateException("Current page of result-set does not reference a next page.")).map(URI::create).map(URI::getRawQuery);
        if (nextQuery.isFailure()) {
            String message = "Unable to extract query parameters for querying next page of result-set.";
            return Try.failure((Throwable)new ODataRequestException(request, "Unable to extract query parameters for querying next page of result-set.", nextQuery.getCause()));
        }
        log.debug("Querying OData service for next page {}", nextQuery.get());
        ODataRequestRead nextReadRequest = new ODataRequestRead(request.getServicePath(), request.getResourcePath(), (String)nextQuery.get(), request.getProtocol());
        request.getHeaders().forEach(nextReadRequest::addHeader);
        return Try.of((CheckedFunction0 & Serializable)() -> nextReadRequest.execute(httpClient));
    }

    public boolean hasPayload() {
        return this.getHttpResponse().getEntity() != null;
    }

    private void assertNonEmptyPayload() {
        if (!this.hasPayload()) {
            throw new ODataDeserializationException(this.getODataRequest(), this.getHttpResponse(), "OData response did not contain any payload.", null);
        }
    }

    private void assertResultTypeIsNotVoid(@Nonnull Class<?> cls) {
        if (Void.class.equals(cls)) {
            throw new IllegalArgumentException("Interpreting results as Void is not allowed.");
        }
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestResultGeneric)) {
            return false;
        }
        ODataRequestResultGeneric other = (ODataRequestResultGeneric)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isBufferHttpResponse != other.isBufferHttpResponse) {
            return false;
        }
        ODataResponseDeserializer this$deserializer = this.deserializer;
        ODataResponseDeserializer other$deserializer = other.deserializer;
        if (this$deserializer == null ? other$deserializer != null : !this$deserializer.equals(other$deserializer)) {
            return false;
        }
        HttpResponse this$bufferedHttpResponse = this.bufferedHttpResponse;
        HttpResponse other$bufferedHttpResponse = other.bufferedHttpResponse;
        if (this$bufferedHttpResponse == null ? other$bufferedHttpResponse != null : !this$bufferedHttpResponse.equals(other$bufferedHttpResponse)) {
            return false;
        }
        ODataRequestGeneric this$oDataRequest = this.getODataRequest();
        ODataRequestGeneric other$oDataRequest = other.getODataRequest();
        if (this$oDataRequest == null ? other$oDataRequest != null : !((Object)this$oDataRequest).equals(other$oDataRequest)) {
            return false;
        }
        HttpResponse this$httpResponse = this.getHttpResponse();
        HttpResponse other$httpResponse = other.getHttpResponse();
        if (this$httpResponse == null ? other$httpResponse != null : !this$httpResponse.equals(other$httpResponse)) {
            return false;
        }
        NumberDeserializationStrategy this$numberStrategy = this.numberStrategy;
        NumberDeserializationStrategy other$numberStrategy = other.numberStrategy;
        return !(this$numberStrategy == null ? other$numberStrategy != null : !((Object)((Object)this$numberStrategy)).equals((Object)other$numberStrategy));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestResultGeneric;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isBufferHttpResponse ? 79 : 97);
        ODataResponseDeserializer $deserializer = this.deserializer;
        result = result * 59 + ($deserializer == null ? 43 : $deserializer.hashCode());
        HttpResponse $bufferedHttpResponse = this.bufferedHttpResponse;
        result = result * 59 + ($bufferedHttpResponse == null ? 43 : $bufferedHttpResponse.hashCode());
        ODataRequestGeneric $oDataRequest = this.getODataRequest();
        result = result * 59 + ($oDataRequest == null ? 43 : ((Object)$oDataRequest).hashCode());
        HttpResponse $httpResponse = this.getHttpResponse();
        result = result * 59 + ($httpResponse == null ? 43 : $httpResponse.hashCode());
        NumberDeserializationStrategy $numberStrategy = this.numberStrategy;
        result = result * 59 + ($numberStrategy == null ? 43 : ((Object)((Object)$numberStrategy)).hashCode());
        return result;
    }

    @Override
    @Nonnull
    @Generated
    public ODataRequestGeneric getODataRequest() {
        return this.oDataRequest;
    }

    @Nullable
    @Generated
    HttpClient getHttpClient() {
        return this.httpClient;
    }
}

