/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartHttpResponse;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartParser;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHealthyResponseValidator;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestBatch;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultMultipart;
import io.vavr.CheckedFunction0;
import io.vavr.Lazy;
import io.vavr.Tuple2;
import io.vavr.control.Try;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class ODataRequestResultMultipartGeneric
implements ODataRequestResultMultipart,
ODataRequestResult {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestResultMultipartGeneric.class);
    private static final String MSG_ON_FAILURE = "Failed to read response entity from OData request result. Please make sure the entity is not consumed already by the application.";
    @Nonnull
    private final ODataRequestBatch batchRequest;
    @Nonnull
    private final HttpResponse httpResponse;
    @Nonnull
    private final Lazy<Try<List<List<HttpResponse>>>> batchResponses = Lazy.of(this::loadBatchResponses);

    ODataRequestResultMultipartGeneric(@Nonnull ODataRequestBatch oDataRequest, @Nonnull HttpResponse httpResponse) {
        this.batchRequest = oDataRequest;
        this.httpResponse = httpResponse;
    }

    @Override
    @Nonnull
    public ODataRequestBatch getODataRequest() {
        return this.batchRequest;
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric getResult(@Nonnull ODataRequestGeneric request) throws ODataResponseException, IllegalArgumentException {
        Tuple2<Integer, Integer> responsePosition = ODataRequestBatch.getBatchItemPosition(this.batchRequest, request);
        if (responsePosition == null) {
            throw new IllegalArgumentException("Incorrect API usage. Please pass the original OData request reference that was handled as batch request item.");
        }
        log.debug("Looking for request {} in batch response at position {}", (Object)request, responsePosition);
        List<HttpResponse> subResponses = this.getBatchedResponses().get((Integer)responsePosition._1());
        boolean isSingleResponse = responsePosition._2() == null || (Integer)responsePosition._2() >= subResponses.size();
        HttpResponse response = subResponses.get(isSingleResponse ? 0 : (Integer)responsePosition._2());
        if (response == null) {
            String msg = "Illegal payload for OData batch response item.";
            throw new ODataDeserializationException(this.batchRequest, this.httpResponse, "Illegal payload for OData batch response item.", null);
        }
        ODataRequestResultGeneric result = new ODataRequestResultGeneric(request, response);
        ODataHealthyResponseValidator.requireHealthyResponse(result);
        return result;
    }

    @Nonnull
    public List<List<HttpResponse>> getBatchedResponses() {
        return (List)((Try)this.batchResponses.get()).getOrElseThrow(e -> new ODataResponseException(this.getBatchRequest(), this.getHttpResponse(), "Failed to read batch response.", (Throwable)e));
    }

    @Nonnull
    private Try<List<List<HttpResponse>>> loadBatchResponses() {
        return Try.of((CheckedFunction0 & Serializable)() -> MultipartParser.ofHttpResponse(this.getHttpResponse()).toList(MultipartHttpResponse::ofHttpContent));
    }

    @Nonnull
    @Generated
    private ODataRequestBatch getBatchRequest() {
        return this.batchRequest;
    }

    @Override
    @Nonnull
    @Generated
    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }
}

