/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldUntyped;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@Beta
public interface FieldReference
extends Expressions.OperandSingle {
    @Nonnull
    public static FieldUntyped of(@Nonnull String fieldName) {
        return () -> fieldName;
    }

    @Nonnull
    public static FieldUntyped ofPath(String ... fieldNames) {
        String fieldIdentifier = String.join((CharSequence)"/", fieldNames);
        return () -> fieldIdentifier;
    }

    @Nonnull
    public String getFieldName();

    @Override
    @Nonnull
    default public String getExpression(@Nonnull ODataProtocol protocol, @Nonnull Map<String, Predicate<FieldReference>> prefixes) {
        String result = this.getFieldName();
        Optional<String> prefix = prefixes.entrySet().stream().filter(e -> ((Predicate)e.getValue()).test(this)).map(Map.Entry::getKey).findFirst();
        if (prefix.isPresent()) {
            result = prefix.get() + "/" + result;
        }
        return result;
    }
}

