/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.exception;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import io.vavr.CheckedFunction0;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;

public class ODataResponseException
extends ODataException {
    private static final long serialVersionUID = 4615831202194546242L;
    private final int httpCode;
    @Nonnull
    private final Collection<Header> httpHeaders;
    @Nonnull
    @Beta
    private final Option<String> httpBody;

    @Beta
    public ODataResponseException(@Nonnull ODataRequestGeneric request, @Nonnull HttpResponse httpResponse, @Nonnull String message, @Nullable Throwable cause) {
        super(request, message, cause);
        this.httpCode = httpResponse.getStatusLine().getStatusCode();
        this.httpHeaders = Arrays.asList(httpResponse.getAllHeaders());
        this.httpBody = Try.of((CheckedFunction0 & Serializable)() -> EntityUtils.toString((HttpEntity)httpResponse.getEntity(), (Charset)StandardCharsets.UTF_8)).onFailure(this::addSuppressed).toOption();
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataResponseException)) {
            return false;
        }
        ODataResponseException other = (ODataResponseException)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getHttpCode() != other.getHttpCode()) {
            return false;
        }
        Collection<Header> this$httpHeaders = this.getHttpHeaders();
        Collection<Header> other$httpHeaders = other.getHttpHeaders();
        if (this$httpHeaders == null ? other$httpHeaders != null : !((Object)this$httpHeaders).equals(other$httpHeaders)) {
            return false;
        }
        Option<String> this$httpBody = this.getHttpBody();
        Option<String> other$httpBody = other.getHttpBody();
        return !(this$httpBody == null ? other$httpBody != null : !this$httpBody.equals(other$httpBody));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataResponseException;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getHttpCode();
        Collection<Header> $httpHeaders = this.getHttpHeaders();
        result = result * 59 + ($httpHeaders == null ? 43 : ((Object)$httpHeaders).hashCode());
        Option<String> $httpBody = this.getHttpBody();
        result = result * 59 + ($httpBody == null ? 43 : $httpBody.hashCode());
        return result;
    }

    @Generated
    public int getHttpCode() {
        return this.httpCode;
    }

    @Nonnull
    @Generated
    public Collection<Header> getHttpHeaders() {
        return this.httpHeaders;
    }

    @Nonnull
    @Generated
    public Option<String> getHttpBody() {
        return this.httpBody;
    }
}

