/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import io.vavr.CheckedFunction1;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpEntityReader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpEntityReader.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    @Nullable
    private final HttpEntity entity;
    @Nonnull
    private final BiFunction<String, Throwable, ? extends RuntimeException> errorHandler;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private <T> T read(@Nonnull CheckedFunction1<InputStream, T> streamConsumer) {
        if (this.entity == null) {
            String msg = "OData response does not contain an HTTP entity.";
            log.warn("OData response does not contain an HTTP entity.");
            throw this.errorHandler.apply("OData response does not contain an HTTP entity.", null);
        }
        try (InputStream content = this.entity.getContent();){
            Object object = streamConsumer.apply((Object)content);
            return (T)object;
        }
        catch (JsonIOException | IOException e) {
            String msg = "OData response stream cannot be read for HTTP entity: ";
            log.debug("OData response stream cannot be read for HTTP entity: " + this.entity, e);
            throw this.errorHandler.apply("OData response stream cannot be read for HTTP entity: " + this.entity.getClass().getName(), e);
        }
        catch (UnsupportedOperationException e) {
            String msg = "OData response entity content cannot be represented as stream object.";
            log.debug("OData response entity content cannot be represented as stream object.", (Throwable)e);
            throw this.errorHandler.apply("OData response entity content cannot be represented as stream object.", e);
        }
        catch (Throwable e) {
            String msg = "A problem occurred while streaming the OData response.";
            log.debug("A problem occurred while streaming the OData response.", e);
            throw this.errorHandler.apply("A problem occurred while streaming the OData response.", e);
        }
    }

    static <T> T read(@Nonnull ODataRequestResult result, @Nonnull CheckedFunction1<JsonElement, T> elementConsumer) {
        return HttpEntityReader.stream(result, (CheckedFunction1 & Serializable)reader -> {
            JsonElement rootElement = JsonParser.parseReader((JsonReader)reader);
            return elementConsumer.apply((Object)rootElement);
        });
    }

    static <T> T stream(@Nonnull ODataRequestResult result, @Nonnull CheckedFunction1<JsonReader, T> readerConsumer) {
        HttpResponse httpResponse = result.getHttpResponse();
        ODataRequestGeneric request = result.getODataRequest();
        BiFunction<String, Throwable, RuntimeException> errorHandler = (msg, e) -> new ODataDeserializationException(request, httpResponse, (String)msg, (Throwable)e);
        return new HttpEntityReader(httpResponse.getEntity(), errorHandler).read((CheckedFunction1 & Serializable)inputStream -> {
            JsonReader reader = new JsonReader((Reader)new InputStreamReader((InputStream)inputStream, DEFAULT_CHARSET));
            return readerConsumer.apply((Object)reader);
        });
    }

    @Generated
    private HttpEntityReader(@Nullable HttpEntity entity, @Nonnull BiFunction<String, Throwable, ? extends RuntimeException> errorHandler) {
        if (errorHandler == null) {
            throw new NullPointerException("errorHandler is marked non-null but is null");
        }
        this.entity = entity;
        this.errorHandler = errorHandler;
    }
}

