/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

class MultipartParserReader {
    @Nonnull
    private final BufferedReader reader;
    @Nonnull
    final String delimiter;
    @Nonnull
    private final String delimiterEnd;
    private boolean started = false;
    private boolean finished = false;

    MultipartParserReader(@Nonnull BufferedReader reader, @Nonnull String delimiter) {
        this.reader = reader;
        this.delimiter = delimiter;
        this.delimiterEnd = delimiter + "--";
    }

    @Nonnull
    public String untilDelimiter() {
        return this.readWhile(line -> !line.equals(this.delimiter) && !line.equals(this.delimiterEnd));
    }

    @Nonnull
    public String untilPayload() {
        return this.readWhile(StringUtils::isNotEmpty);
    }

    @Nonnull
    private String readWhile(@Nonnull Predicate<String> recordFlag) {
        this.started = true;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while (!this.finished && (line = this.reader.readLine()) != null) {
                if (!recordFlag.test(line)) {
                    if (this.delimiterEnd.equals(line)) {
                        this.finished = true;
                    }
                    return sb.toString();
                }
                sb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to parse multi-part text.", e);
        }
        this.finished = true;
        return sb.toString();
    }

    @Generated
    public boolean isStarted() {
        return this.started;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }
}

