/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client;

import com.google.common.annotations.Beta;
import com.sap.cloud.sdk.datamodel.odata.client.JsonLookup;
import com.sap.cloud.sdk.datamodel.odata.client.JsonPath;
import com.sap.cloud.sdk.datamodel.odata.client.ODataLiteralSerializer;
import com.sap.cloud.sdk.datamodel.odata.client.ODataResponseDescriptor;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import lombok.Generated;

@Beta
public interface ODataProtocol
extends ODataResponseDescriptor,
ODataLiteralSerializer {
    public static final ODataProtocol V2 = new ODataProtocolV2();
    public static final ODataProtocol V4 = new ODataProtocolV4();

    @Nonnull
    public String getProtocolVersion();

    @Nonnull
    public Map.Entry<String, String> getQueryOptionInlineCount(boolean var1);

    default public boolean isEqualTo(@Nonnull ODataProtocol otherProtocol) {
        return otherProtocol.getProtocolVersion().equals(this.getProtocolVersion());
    }

    @Beta
    public static final class ODataProtocolV4
    implements ODataProtocol {
        private final String protocolVersion = "4.0";
        private final JsonLookup pathToResultSet = JsonLookup.of(JsonPath.of("value"));
        private final JsonLookup pathToResultSingle = JsonLookup.of(JsonPath.ofRoot());
        private final JsonLookup pathToResultPrimitive = JsonLookup.of(JsonPath.of("value"));
        private final JsonLookup pathToInlineCount = JsonLookup.of(JsonPath.of("@odata.count"), JsonPath.of("@count"));
        private final JsonLookup pathToNextLink = JsonLookup.of(JsonPath.of("@odata.nextLink"), JsonPath.of("@nextLink"));
        private final JsonLookup pathToDeltaLink = JsonLookup.of(JsonPath.of("@odata.deltaLink"), JsonPath.of("@deltaLink"));
        private final Function<Number, String> NumberSerializer = Object::toString;
        private final Function<UUID, String> UUIDSerializer = UUID::toString;
        private final Function<OffsetDateTime, String> DateTimeOffsetSerializer = v -> v.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        private final Function<LocalTime, String> TimeOfDaySerializer = v -> v.format(DateTimeFormatter.ISO_LOCAL_TIME);
        private final Function<LocalDateTime, String> DateTimeSerializer = v -> this.DateTimeOffsetSerializer.apply(v.atOffset(ZoneOffset.UTC));

        @Override
        @Nonnull
        public Map.Entry<String, String> getQueryOptionInlineCount(boolean optionEnabled) {
            return new AbstractMap.SimpleEntry<String, String>("$count", optionEnabled ? "true" : "false");
        }

        @Nonnull
        public String toString() {
            return "OData 4.0";
        }

        @Override
        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultSet() {
            return this.pathToResultSet;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultSingle() {
            return this.pathToResultSingle;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultPrimitive() {
            return this.pathToResultPrimitive;
        }

        @Override
        @Generated
        public JsonLookup getPathToInlineCount() {
            return this.pathToInlineCount;
        }

        @Override
        @Generated
        public JsonLookup getPathToNextLink() {
            return this.pathToNextLink;
        }

        @Override
        @Generated
        public JsonLookup getPathToDeltaLink() {
            return this.pathToDeltaLink;
        }

        @Override
        @Generated
        public Function<Number, String> getNumberSerializer() {
            return this.NumberSerializer;
        }

        @Override
        @Generated
        public Function<UUID, String> getUUIDSerializer() {
            return this.UUIDSerializer;
        }

        @Override
        @Generated
        public Function<OffsetDateTime, String> getDateTimeOffsetSerializer() {
            return this.DateTimeOffsetSerializer;
        }

        @Override
        @Generated
        public Function<LocalTime, String> getTimeOfDaySerializer() {
            return this.TimeOfDaySerializer;
        }

        @Override
        @Generated
        public Function<LocalDateTime, String> getDateTimeSerializer() {
            return this.DateTimeSerializer;
        }
    }

    @Beta
    public static final class ODataProtocolV2
    implements ODataProtocol {
        private final String protocolVersion = "2.0";
        private final JsonLookup pathToResultSet = JsonLookup.of(JsonPath.of("d", "results"));
        private final JsonLookup pathToResultSingle = JsonLookup.of(JsonPath.of("d"));
        private final JsonLookup pathToResultPrimitive = JsonLookup.of(JsonPath.of("d", JsonPath.WILDCARD));
        private final JsonLookup pathToInlineCount = JsonLookup.of(JsonPath.of("__count"));
        private final JsonLookup pathToNextLink = JsonLookup.of(JsonPath.of("__next"));
        private final JsonLookup pathToDeltaLink = JsonLookup.empty();
        private final Function<Number, String> NumberSerializer = ODataProtocolV2::numberToString;
        private final Function<UUID, String> UUIDSerializer = v -> String.format("guid'%s'", v);
        private final Function<OffsetDateTime, String> DateTimeOffsetSerializer = v -> String.format("datetimeoffset'%s'", v.format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        private final Function<LocalTime, String> TimeOfDaySerializer = v -> String.format("time'%s'", Duration.ofNanos(v.toNanoOfDay()));
        private final Function<LocalDateTime, String> DateTimeSerializer = v -> String.format("datetime'%s'", v.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME));

        private static String numberToString(Number n) {
            String result;
            if (n instanceof Integer) {
                result = Integer.toString(n.intValue());
            } else if (n instanceof Short) {
                result = Short.toString(n.shortValue());
            } else if (n instanceof Byte) {
                result = Byte.toString(n.byteValue());
            } else if (n instanceof Long) {
                result = n.longValue() + "L";
            } else if (n instanceof Float) {
                result = n.floatValue() + "f";
            } else if (n instanceof Double) {
                result = n.doubleValue() + "d";
            } else if (n instanceof BigDecimal) {
                result = ((BigDecimal)n).toPlainString() + "M";
            } else {
                String message = String.format("Unrecognized number type: %s. Should be one of: Integer, Long, Float, Double, BigDecimal.", n.getClass());
                throw new IllegalStateException(message);
            }
            return result;
        }

        @Override
        @Nonnull
        public Map.Entry<String, String> getQueryOptionInlineCount(boolean optionEnabled) {
            return new AbstractMap.SimpleEntry<String, String>("$inlinecount", optionEnabled ? "allpages" : "none");
        }

        @Nonnull
        public String toString() {
            return "OData 2.0";
        }

        @Override
        @Generated
        public String getProtocolVersion() {
            return this.protocolVersion;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultSet() {
            return this.pathToResultSet;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultSingle() {
            return this.pathToResultSingle;
        }

        @Override
        @Generated
        public JsonLookup getPathToResultPrimitive() {
            return this.pathToResultPrimitive;
        }

        @Override
        @Generated
        public JsonLookup getPathToInlineCount() {
            return this.pathToInlineCount;
        }

        @Override
        @Generated
        public JsonLookup getPathToNextLink() {
            return this.pathToNextLink;
        }

        @Override
        @Generated
        public JsonLookup getPathToDeltaLink() {
            return this.pathToDeltaLink;
        }

        @Override
        @Generated
        public Function<Number, String> getNumberSerializer() {
            return this.NumberSerializer;
        }

        @Override
        @Generated
        public Function<UUID, String> getUUIDSerializer() {
            return this.UUIDSerializer;
        }

        @Override
        @Generated
        public Function<OffsetDateTime, String> getDateTimeOffsetSerializer() {
            return this.DateTimeOffsetSerializer;
        }

        @Override
        @Generated
        public Function<LocalTime, String> getTimeOfDaySerializer() {
            return this.TimeOfDaySerializer;
        }

        @Override
        @Generated
        public Function<LocalDateTime, String> getDateTimeSerializer() {
            return this.DateTimeSerializer;
        }
    }
}

