/*
 * Copyright (c) 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.datamodel.odata.client.query;

import com.google.common.annotations.Beta;

/**
 * Used with <b>orderBy</b> methods in entity fluent helper objects to set the sorting order of field values.
 */
@Beta
public enum Order
{
    /**
     * Sort field values in ascending order.
     */
    ASC,

    /**
     * Sort field values in descending order.
     */
    DESC
}
