/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.escape.Escaper;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.Tuple;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public abstract class AbstractODataParameters {
    @Nonnull
    private final Map<String, Expressions.OperandSingle> parameters = new LinkedHashMap<String, Expressions.OperandSingle>();
    @Nonnull
    private final ODataProtocol protocol;

    <PrimitiveT> void addParameterInternal(@Nonnull String parameterName, @Nullable PrimitiveT value) {
        if (this.parameters.containsKey(parameterName)) {
            throw new IllegalArgumentException("Cannot add parameter \"" + parameterName + "\": A parameter by that name already exists.");
        }
        this.parameters.put(parameterName, Expressions.createOperand(value));
    }

    void addParameterSetInternal(@Nonnull Map<String, Object> properties) {
        properties.forEach(this::addParameterInternal);
    }

    @Nonnull
    public String toEncodedString() {
        return this.toStringInternal(UriEncodingStrategy.REGULAR, ParameterFormat.PATH_SHORT);
    }

    @Nonnull
    public String toEncodedString(@Nonnull UriEncodingStrategy strategy) {
        return this.toStringInternal(strategy, ParameterFormat.PATH_SHORT);
    }

    @Nonnull
    public String toString() {
        return this.toStringInternal(UriEncodingStrategy.NONE, ParameterFormat.PATH_SHORT);
    }

    @Nonnull
    String toStringInternal(@Nonnull UriEncodingStrategy strategy, ParameterFormat format) {
        Function<String, String> encoder;
        Function<String, String> function = format.isQuery() ? arg_0 -> ((Escaper)strategy.getQueryPercentEscaper()).escape(arg_0) : (encoder = arg_0 -> ((Escaper)strategy.getPathPercentEscaper()).escape(arg_0));
        if (format == ParameterFormat.PATH_SHORT && this.parameters.size() == 1) {
            Expressions.OperandSingle singleValue = this.parameters.values().iterator().next();
            String parameterValue = singleValue.getExpression(this.protocol);
            parameterValue = encoder.apply(parameterValue);
            parameterValue = String.format("(%s)", parameterValue);
            return parameterValue;
        }
        String keyDelimiter = format.isQuery() ? "&" : ",";
        String keys = this.parameters.entrySet().stream().map(param -> Tuple.of(param.getKey(), param.getValue())).map(param -> param.map2(val -> val.getExpression(this.protocol))).map(param -> param.map2(encoder)).map(param -> (String)param.apply((key, val) -> String.format("%s=%s", key, val))).collect(Collectors.joining(keyDelimiter));
        if (!format.isQuery()) {
            keys = String.format("(%s)", keys);
        }
        return keys;
    }

    @Generated
    AbstractODataParameters(@Nonnull ODataProtocol protocol) {
        if (protocol == null) {
            throw new NullPointerException("protocol is marked non-null but is null");
        }
        this.protocol = protocol;
    }

    @Nonnull
    @Generated
    Map<String, Expressions.OperandSingle> getParameters() {
        return this.parameters;
    }

    @Nonnull
    @Generated
    public ODataProtocol getProtocol() {
        return this.protocol;
    }

    static enum ParameterFormat {
        PATH(false, false),
        PATH_SHORT(false, true),
        QUERY(true, false);

        private final boolean isQuery;
        private final boolean isShort;

        private ParameterFormat(boolean isQuery, boolean isShort) {
            this.isQuery = isQuery;
            this.isShort = isShort;
        }

        @Generated
        public boolean isQuery() {
            return this.isQuery;
        }

        @Generated
        public boolean isShort() {
            return this.isShort;
        }
    }
}

