/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.sap.cloud.sdk.datamodel.odata.client.expression.Expressions;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpression;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueEnum;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public interface FilterExpressionLogical {
    @Nonnull
    public static ValueBoolean.Expression equalTo(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("eq", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression notEqualTo(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("ne", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression greaterThan(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("gt", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression greaterThanEquals(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("ge", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression lessThan(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("lt", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression lessThanEquals(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.Operand operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("le", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression and(@Nonnull ValueBoolean operand1, @Nonnull ValueBoolean operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("and", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression or(@Nonnull ValueBoolean operand1, @Nonnull ValueBoolean operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("or", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression not(@Nonnull ValueBoolean operand) {
        FilterExpression expression = Expressions.createOperatorPrefix("not", operand);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression has(@Nonnull Expressions.OperandSingle operand1, @Nonnull ValueEnum operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("has", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }

    @Nonnull
    public static ValueBoolean.Expression in(@Nonnull Expressions.Operand operand1, Expressions.Operand ... operands2) {
        Expressions.OperandMultiple operand2 = (protocol, prefixes) -> "(" + Arrays.stream(operands2).map(o -> o.getExpression(protocol)).collect(Collectors.joining(",")) + ")";
        return FilterExpressionLogical.in(operand1, operand2);
    }

    @Nonnull
    public static ValueBoolean.Expression in(@Nonnull Expressions.Operand operand1, @Nonnull Expressions.OperandMultiple operand2) {
        FilterExpression expression = Expressions.createFunctionInfix("in", operand1, operand2);
        return new ValueBoolean.Expression(expression);
    }
}

