/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.query;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.OrderExpression;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import io.vavr.control.Option;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

class QuerySerializer {
    private static final String SEPARATOR_SUB_QUERY = ";";
    private static final String SEPARATOR_ROOT_QUERY = "&";
    private static final Map<String, BiFunction<StructuredQuery, Boolean, Object>> QUERY_TO_STRING_MAP = ImmutableMap.builder().put((Object)"$select=%s", QuerySerializer::selectorsToQueryString).put((Object)"$expand=%s", QuerySerializer::expansionsToQueryString).put((Object)"$filter=%s", QuerySerializer::filtersToQueryString).put((Object)"$top=%s", (q, applyEncoding) -> q.top).put((Object)"$skip=%s", (q, applyEncoding) -> q.skip).put((Object)"$orderby=%s", QuerySerializer::orderByToQueryString).put((Object)"$search=%s", (q, applyEncoding) -> QuerySerializer.conditionalEncode(q.search, applyEncoding)).build();

    QuerySerializer() {
    }

    @Nonnull
    static String serializeAndEncodeQuery(@Nonnull StructuredQuery query, boolean applyEncoding) {
        ArrayList parameters = new ArrayList();
        QUERY_TO_STRING_MAP.forEach((parameterString, valueFunction) -> Option.of(valueFunction.apply(query, applyEncoding)).filter(q -> q instanceof String ? !"".equals(q) : q != null).map(q -> String.format(parameterString, q)).forEach(parameters::add));
        if (query.isRoot()) {
            query.getCustomParameters().forEach((key, value) -> parameters.add(key + "=" + QuerySerializer.conditionalEncode(value, applyEncoding)));
        }
        String queryElementSeparator = query.isRoot() ? SEPARATOR_ROOT_QUERY : SEPARATOR_SUB_QUERY;
        return Joiner.on((String)queryElementSeparator).join(parameters);
    }

    @Nonnull
    private static String selectorsToQueryString(@Nonnull StructuredQuery q, boolean applyEncoding) {
        List<String> selectors = QuerySerializer.getSelectors(q, applyEncoding);
        return Joiner.on((String)",").join(selectors);
    }

    @Nonnull
    private static List<String> getSelectors(@Nonnull StructuredQuery query, boolean applyEncoding) {
        List<String> selectors = query.getSimpleSelectors().stream().map(result -> applyEncoding ? ODataUriFactory.encodeQuery(result) : result).collect(Collectors.toList());
        if (query.getProtocol() == ODataProtocol.V2) {
            for (StructuredQuery childQuery : query.getComplexSelectors()) {
                String propertyName = childQuery.getEntityOrPropertyName();
                if (applyEncoding) {
                    propertyName = ODataUriFactory.encodeQuery(propertyName);
                }
                for (String select : QuerySerializer.getSelectors(childQuery, applyEncoding)) {
                    selectors.add(propertyName + "/" + select);
                }
            }
        }
        return selectors;
    }

    @Nonnull
    private static String expansionsToQueryString(@Nonnull StructuredQuery q, boolean applyEncoding) {
        List<String> filters = QuerySerializer.getExpansions(q, applyEncoding);
        return Joiner.on((String)",").join(filters);
    }

    @Nonnull
    private static List<String> getExpansions(@Nonnull StructuredQuery query, boolean applyEncoding) {
        ArrayList<String> expansions = new ArrayList<String>();
        Collection<StructuredQuery> complexSelectors = query.getComplexSelectors();
        for (StructuredQuery subQuery : complexSelectors) {
            String subQueryString;
            String propertyName = subQuery.getEntityOrPropertyName();
            if (applyEncoding) {
                propertyName = ODataUriFactory.encodeQuery(propertyName);
            }
            if (query.getProtocol() == ODataProtocol.V2) {
                expansions.add(propertyName);
                for (String expand : QuerySerializer.getExpansions(subQuery, applyEncoding)) {
                    expansions.add(propertyName + "/" + expand);
                }
                continue;
            }
            String string = subQueryString = applyEncoding ? subQuery.getEncodedQueryString() : subQuery.getQueryString();
            if (!subQueryString.isEmpty()) {
                propertyName = propertyName + "(" + subQueryString + ")";
            }
            expansions.add(propertyName);
        }
        return expansions;
    }

    @Nonnull
    private static String filtersToQueryString(@Nonnull StructuredQuery q, boolean applyEncoding) {
        List filters = q.getFilters().stream().map(filter -> filter.getExpression(q.getProtocol())).collect(Collectors.toList());
        return QuerySerializer.conditionalEncode(Joiner.on((String)" and ").join(filters), applyEncoding);
    }

    @Nullable
    private static String orderByToQueryString(@Nonnull StructuredQuery q, boolean applyEncoding) {
        String orderBy = (String)Option.of((Object)q.getOrderBy()).map(OrderExpression::toOrderByString).getOrNull();
        return QuerySerializer.conditionalEncode(orderBy, applyEncoding);
    }

    @Nullable
    private static String conditionalEncode(@Nullable String input, boolean applyEncoding) {
        return applyEncoding && input != null ? ODataUriFactory.encodeQuery(input) : input;
    }
}

