/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.base.Charsets;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataConnectionException;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import java.io.IOException;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ODataHttpRequest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataHttpRequest.class);
    @Nonnull
    private final ODataRequestGeneric odataRequest;
    @Nonnull
    private final HttpClient httpClient;
    @Nullable
    private final HttpEntity requestBody;

    static ODataHttpRequest withoutBody(@Nonnull ODataRequestGeneric requestGeneric, @Nonnull HttpClient httpClient) {
        return ODataHttpRequest.forHttpEntity(requestGeneric, httpClient, null);
    }

    static ODataHttpRequest forBodyJson(@Nonnull ODataRequestGeneric requestGeneric, @Nonnull HttpClient httpClient, @Nonnull String json) {
        StringEntity requestBody = new StringEntity(json, Charsets.UTF_8);
        requestBody.setContentType("application/json");
        return ODataHttpRequest.forHttpEntity(requestGeneric, httpClient, (HttpEntity)requestBody);
    }

    static ODataHttpRequest forBodyText(@Nonnull ODataRequestGeneric requestGeneric, @Nonnull HttpClient httpClient, @Nonnull String text) {
        return ODataHttpRequest.forHttpEntity(requestGeneric, httpClient, (HttpEntity)new StringEntity(text, Charsets.UTF_8));
    }

    static ODataHttpRequest forHttpEntity(@Nonnull ODataRequestGeneric requestGeneric, @Nonnull HttpClient httpClient, @Nullable HttpEntity httpEntity) {
        return new ODataHttpRequest(requestGeneric, httpClient, httpEntity);
    }

    @Nonnull
    private HttpResponse requestResource(@Nonnull Function<URI, HttpRequestBase> requestCreator) {
        HttpRequestBase httpRequest = requestCreator.apply(this.getUri());
        this.odataRequest.getHeaders().forEach((k, values) -> values.forEach(v -> httpRequest.addHeader(k, v)));
        if (httpRequest instanceof HttpEntityEnclosingRequest) {
            if (this.requestBody != null) {
                ((HttpEntityEnclosingRequest)httpRequest).setEntity(this.requestBody);
            } else {
                log.warn("The HTTP request {} was expecting an entity, but none was provided.", (Object)httpRequest);
            }
        }
        this.odataRequest.getListeners().forEach(v -> v.listenOnRequest(httpRequest));
        try {
            return this.httpClient.execute((HttpUriRequest)httpRequest);
        }
        catch (ClientProtocolException e) {
            log.debug("Connection could not be established.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection could not be established.", e);
        }
        catch (ConnectionPoolTimeoutException e) {
            log.debug("Connection pool timed out.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Time out occurred because of a probable connection leak. Please execute your request with try-with-resources to ensure resources are properly closed.If you are using the OData client instead to execute your request, explicitly consume the entity of the associated HttpResponse using EntityUtils.consume(httpEntity)", e);
        }
        catch (IOException e) {
            log.debug("Connection was aborted.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection was aborted.", e);
        }
        catch (Exception e) {
            log.debug("Connection failed.", (Throwable)e);
            throw new ODataConnectionException(this.odataRequest, (HttpUriRequest)httpRequest, "Connection failed.", e);
        }
    }

    @Nonnull
    HttpResponse requestGet() {
        return this.requestResource(HttpGet::new);
    }

    @Nonnull
    HttpResponse requestPost() {
        return this.requestResource(HttpPost::new);
    }

    @Nonnull
    HttpResponse requestPatch() {
        return this.requestResource(HttpPatch::new);
    }

    @Nonnull
    HttpResponse requestPut() {
        return this.requestResource(HttpPut::new);
    }

    @Nonnull
    HttpResponse requestDelete() {
        return this.requestResource(HttpDelete::new);
    }

    private URI getUri() {
        return this.odataRequest.getRelativeUri();
    }

    @Generated
    private ODataHttpRequest(@Nonnull ODataRequestGeneric odataRequest, @Nonnull HttpClient httpClient, @Nullable HttpEntity requestBody) {
        if (odataRequest == null) {
            throw new NullPointerException("odataRequest is marked non-null but is null");
        }
        if (httpClient == null) {
            throw new NullPointerException("httpClient is marked non-null but is null");
        }
        this.odataRequest = odataRequest;
        this.httpClient = httpClient;
        this.requestBody = requestBody;
    }
}

