/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.query.StructuredQuery;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.control.Try;
import java.net.URI;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.client.HttpClient;

public class ODataRequestRead
extends ODataRequestGeneric {
    @Nonnull
    private final String queryString;

    public ODataRequestRead(@Nonnull String servicePath, @Nonnull String entityName, @Nullable String encodedQuery, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(entityName), encodedQuery, protocol);
    }

    public ODataRequestRead(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nullable String encodedQuery, @Nonnull ODataProtocol protocol) {
        super(servicePath, entityPath, protocol);
        this.queryString = encodedQuery != null ? encodedQuery : "";
    }

    public ODataRequestRead(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nonnull StructuredQuery query) {
        this(servicePath, entityPath.addSegment(query.getEntityOrPropertyName()), query.getEncodedQueryString(), query.getProtocol());
    }

    @Override
    @Nonnull
    public URI getRelativeUri(@Nonnull UriEncodingStrategy strategy) {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), strategy);
    }

    @Override
    @Nonnull
    public String getRequestQuery() {
        String genericQueryString = super.getRequestQuery();
        if (!genericQueryString.isEmpty() && !this.queryString.isEmpty()) {
            return this.queryString + "&" + genericQueryString;
        }
        return this.queryString + genericQueryString;
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = ODataHttpRequest.withoutBody(this, httpClient);
        Try<ODataRequestResultGeneric> result = this.csrfTokenRetriever == null ? this.tryExecute(request::requestGet, httpClient) : this.tryExecuteWithCsrfToken(httpClient, request::requestGet);
        return (ODataRequestResultGeneric)result.get();
    }

    @Nonnull
    @Generated
    public String getQueryString() {
        return this.queryString;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestRead)) {
            return false;
        }
        ODataRequestRead other = (ODataRequestRead)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$queryString = this.getQueryString();
        String other$queryString = other.getQueryString();
        return !(this$queryString == null ? other$queryString != null : !this$queryString.equals(other$queryString));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestRead;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $queryString = this.getQueryString();
        result = result * 59 + ($queryString == null ? 43 : $queryString.hashCode());
        return result;
    }
}

