/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartHttpResponse;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartParserReader;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartSpliterator;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MultipartParser {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultipartParser.class);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final String MULTIPART_MIXED_MIME_TYPE = "multipart/mixed";
    private static final String MULTIPART_MIXED_BOUNDARY = "boundary";
    @Nonnull
    private final BufferedReader reader;
    @Nonnull
    private final String delimiter;

    public static MultipartParser ofHttpResponse(@Nonnull HttpResponse httpResponse) {
        HttpEntity entity = httpResponse.getEntity();
        if (entity == null) {
            throw new IllegalStateException("HTTP response does not contain a content.");
        }
        InputStream inputStream = (InputStream)Try.of(() -> ((HttpEntity)entity).getContent()).getOrElseThrow(e -> new IllegalStateException("Unable to read HTTP content.", (Throwable)e));
        String delimiter = MultipartParser.getDelimiterFromHttpResponse(httpResponse).orElseThrow(() -> new IllegalStateException("No delimiter found in HTTP header."));
        Charset charsetValue = (Charset)Try.of((CheckedFunction0 & Serializable)() -> ContentType.get((HttpEntity)entity)).onFailure(e -> log.debug("Unable to detect charset, using to default charset {}", (Object)DEFAULT_CHARSET)).toOption().map(ContentType::getCharset).filter(Objects::nonNull).peek(c -> log.debug("Using detected charset {}", c)).getOrElse((Object)DEFAULT_CHARSET);
        return MultipartParser.ofInputStream(inputStream, charsetValue, delimiter);
    }

    @Nonnull
    public static MultipartParser ofInputStream(@Nonnull InputStream contentStream, @Nonnull Charset contentCharset, @Nonnull String delimiter) {
        BufferedReader reader = (BufferedReader)Try.of((CheckedFunction0 & Serializable)() -> new InputStreamReader(contentStream, contentCharset)).map(BufferedReader::new).getOrElseThrow(e -> new IllegalStateException("Unable to initialize multi-part parsing.", (Throwable)e));
        return new MultipartParser(reader, delimiter);
    }

    @Nonnull
    public List<List<String>> toList() {
        return this.toList(Function.identity());
    }

    @Nonnull
    public <T> List<List<T>> toList(@Nonnull Function<String, T> transformation) {
        return this.toStream().map(segments -> segments.map(transformation).collect(Collectors.toList())).collect(Collectors.toList());
    }

    @Nonnull
    public Stream<Stream<String>> toStream() {
        Stream<Spliterator> result = StreamSupport.stream(this::createSpliterator, 1296, false);
        AtomicReference previous = new AtomicReference(Spliterators.emptySpliterator());
        return result.map(currentSpliterator -> {
            previous.getAndSet(currentSpliterator).forEachRemaining(item -> log.trace("Skipping element {}", item));
            return StreamSupport.stream(currentSpliterator, false);
        });
    }

    private Spliterator<Spliterator<String>> createSpliterator() {
        MultipartParserReader batchRead = new MultipartParserReader(this.reader, this.delimiter);
        batchRead.untilDelimiter();
        return new MultipartSpliterator<Spliterator<String>>(() -> {
            if (batchRead.isFinished()) {
                return null;
            }
            String segmentHead = batchRead.untilPayload();
            Optional<String> maybeChangesetBoundary = MultipartParser.getDelimiterFromString(segmentHead);
            if (maybeChangesetBoundary.isPresent()) {
                return this.getChangeset(maybeChangesetBoundary.get(), batchRead);
            }
            String content = batchRead.untilDelimiter();
            return Collections.singleton(content).spliterator();
        });
    }

    @Nonnull
    private Spliterator<String> getChangeset(@Nonnull String changesetDelimiter, MultipartParserReader batchRead) {
        MultipartParserReader changesetRead = new MultipartParserReader(this.reader, changesetDelimiter);
        changesetRead.untilDelimiter();
        return new MultipartSpliterator<String>(() -> {
            if (changesetRead.isFinished()) {
                return null;
            }
            String subSegmentHead = changesetRead.untilPayload();
            log.trace("Iterating Batch changeset segment with header {}", (Object)subSegmentHead);
            String content = changesetRead.untilDelimiter();
            if (changesetRead.isFinished()) {
                batchRead.untilDelimiter();
            }
            return content;
        });
    }

    @Nonnull
    private static Optional<String> getDelimiterFromString(@Nonnull String segmentHead) {
        List<Header> segmentHeaders = MultipartHttpResponse.getHeadersFromString(segmentHead);
        Optional<ContentType> segmentContentType = MultipartHttpResponse.getContentType(segmentHeaders);
        return segmentContentType.flatMap(MultipartParser::getDelimiterFromContentType);
    }

    @Nonnull
    private static Optional<String> getDelimiterFromContentType(@Nonnull ContentType contentType) {
        String boundary = contentType.getParameter(MULTIPART_MIXED_BOUNDARY);
        return boundary == null ? Optional.empty() : Optional.of("--" + boundary);
    }

    @Nonnull
    private static Optional<String> getDelimiterFromHttpResponse(@Nonnull HttpResponse httpResponse) {
        List<Header> headers = Arrays.asList(httpResponse.getAllHeaders());
        ContentType contentType = MultipartHttpResponse.getContentType(headers).orElse(null);
        if (contentType == null) {
            return Optional.empty();
        }
        if (!MULTIPART_MIXED_MIME_TYPE.equalsIgnoreCase(contentType.getMimeType())) {
            log.debug("Unexpected value in HTTP header \"Content-Type\" of OData batch response: {}", (Object)contentType);
        }
        return MultipartParser.getDelimiterFromContentType(contentType);
    }

    @Generated
    MultipartParser(@Nonnull BufferedReader reader, @Nonnull String delimiter) {
        if (reader == null) {
            throw new NullPointerException("reader is marked non-null but is null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter is marked non-null but is null");
        }
        this.reader = reader;
        this.delimiter = delimiter;
    }
}

