/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.google.common.escape.Escaper;
import com.sap.cloud.sdk.datamodel.odata.client.request.AbstractODataParameters;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public final class ODataResourcePath {
    @Nonnull
    private final List<Tuple2<String, AbstractODataParameters>> segments = new ArrayList<Tuple2<String, AbstractODataParameters>>();

    @Nonnull
    public static ODataResourcePath of(@Nonnull String segment) {
        return new ODataResourcePath().addSegment(segment);
    }

    @Nonnull
    public static ODataResourcePath of(@Nonnull String segment, @Nonnull AbstractODataParameters segmentParameter) {
        return new ODataResourcePath().addSegment(segment, segmentParameter);
    }

    @Nonnull
    public ODataResourcePath addSegment(@Nonnull String segment) {
        return this.addSegment(segment, null);
    }

    @Nonnull
    public ODataResourcePath addSegment(@Nonnull String segment, @Nullable AbstractODataParameters parameters) {
        this.segments.add((Tuple2<String, AbstractODataParameters>)Tuple.of((Object)segment, (Object)parameters));
        return this;
    }

    @Nonnull
    public ODataResourcePath addParameterToLastSegment(@Nonnull AbstractODataParameters parameters) {
        if (this.segments.isEmpty()) {
            throw new IllegalStateException("Cannot add parameter to the last segment because the current path is empty.");
        }
        Tuple2<String, AbstractODataParameters> lastSegment = this.segments.get(this.segments.size() - 1);
        if (lastSegment._2() != null) {
            String msg = String.format("Cannot add parameter for path segment \"%s\". The segment already contains a parameter expression.", lastSegment._2());
            throw new IllegalStateException(msg);
        }
        this.segments.set(this.segments.size() - 1, (Tuple2<String, AbstractODataParameters>)lastSegment.update2((Object)parameters));
        return this;
    }

    @Nonnull
    public String toEncodedPathString() {
        return this.toEncodedPathString(UriEncodingStrategy.REGULAR);
    }

    @Nonnull
    public String toEncodedPathString(@Nonnull UriEncodingStrategy strategy) {
        return "/" + this.segments.stream().map(t -> t.map1(arg_0 -> ((Escaper)strategy.getPathPercentEscaper()).escape(arg_0))).map(t -> t.map2(key -> key != null ? key.toEncodedString(strategy) : "")).map(t -> (String)t._1() + (String)t._2()).collect(Collectors.joining("/"));
    }

    @Nonnull
    public String toString() {
        return "/" + this.segments.stream().map(t -> t.map2(key -> key != null ? key.toString() : "")).map(t -> (String)t._1() + (String)t._2()).collect(Collectors.joining("/"));
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataResourcePath)) {
            return false;
        }
        ODataResourcePath other = (ODataResourcePath)o;
        List<Tuple2<String, AbstractODataParameters>> this$segments = this.getSegments();
        List<Tuple2<String, AbstractODataParameters>> other$segments = other.getSegments();
        return !(this$segments == null ? other$segments != null : !((Object)this$segments).equals(other$segments));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Tuple2<String, AbstractODataParameters>> $segments = this.getSegments();
        result = result * 59 + ($segments == null ? 43 : ((Object)$segments).hashCode());
        return result;
    }

    @Nonnull
    @Generated
    public List<Tuple2<String, AbstractODataParameters>> getSegments() {
        return this.segments;
    }
}

