/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.gson.JsonObject;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataDeserializationException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataResponseException;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataServiceError;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataServiceErrorException;
import com.sap.cloud.sdk.datamodel.odata.client.request.HttpEntityReader;
import com.sap.cloud.sdk.datamodel.odata.client.request.MultipartHttpResponse;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataGsonBuilder;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestBatch;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResult;
import com.sap.cloud.sdk.result.GsonResultElementFactory;
import com.sap.cloud.sdk.result.GsonResultObject;
import com.sap.cloud.sdk.result.ResultObject;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import io.vavr.control.Try;
import java.io.Serializable;
import javax.annotation.Nonnull;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;

class ODataHealthyResponseValidator {
    ODataHealthyResponseValidator() {
    }

    static void requireHealthyResponse(@Nonnull ODataRequestResult result) {
        ODataRequestGeneric originalRequest = result.getODataRequest();
        StatusLine statusLine = result.getStatusLine();
        if (statusLine != null && statusLine.getStatusCode() < 400) {
            return;
        }
        HttpResponse httpResponse = result.getHttpResponse();
        ODataRequestGeneric requestRelevantForException = (ODataRequestGeneric)ODataHealthyResponseValidator.findPotentialBatchItem(httpResponse, originalRequest).getOrElse((Object)originalRequest);
        Integer statusCode = statusLine == null ? null : Integer.valueOf(statusLine.getStatusCode());
        String msg = "The HTTP response code (" + statusCode + ") indicates an error.";
        Try odataError = Try.of((CheckedFunction0 & Serializable)() -> ODataHealthyResponseValidator.loadErrorFromResponse(result));
        if (odataError.isSuccess()) {
            String msgError = msg + " The OData service responded with an error message.";
            throw new ODataServiceErrorException(requestRelevantForException, httpResponse, msgError, null, (ODataServiceError)odataError.get());
        }
        throw new ODataResponseException(requestRelevantForException, httpResponse, msg, null);
    }

    @Nonnull
    private static Option<ODataRequestGeneric> findPotentialBatchItem(HttpResponse httpResponse, ODataRequestGeneric request) {
        ODataRequestBatch requestBatch;
        block9: {
            block8: {
                if (!(request instanceof ODataRequestBatch)) break block8;
                requestBatch = (ODataRequestBatch)request;
                if (httpResponse instanceof MultipartHttpResponse) break block9;
            }
            return Option.none();
        }
        MultipartHttpResponse multipartHttpResponse = (MultipartHttpResponse)httpResponse;
        Integer failedBatchRequestNumber = multipartHttpResponse.getContentId();
        if (failedBatchRequestNumber == null) {
            return Option.none();
        }
        for (ODataRequestBatch.BatchItem requestGeneric : requestBatch.getRequests()) {
            ODataRequestBatch.BatchItemSingle single;
            if (requestGeneric instanceof ODataRequestBatch.BatchItemChangeset) {
                ODataRequestBatch.BatchItemChangeset changeset = (ODataRequestBatch.BatchItemChangeset)requestGeneric;
                for (ODataRequestBatch.BatchItemSingle single2 : changeset.getRequests()) {
                    if (single2.getContentId() != failedBatchRequestNumber.intValue()) continue;
                    return Option.of((Object)single2.getRequest());
                }
                continue;
            }
            if (!(requestGeneric instanceof ODataRequestBatch.BatchItemSingle) || (single = (ODataRequestBatch.BatchItemSingle)requestGeneric).getContentId() != failedBatchRequestNumber.intValue()) continue;
            return Option.of((Object)single.getRequest());
        }
        return Option.none();
    }

    @Nonnull
    private static ODataServiceError loadErrorFromResponse(ODataRequestResult result) throws ODataDeserializationException {
        GsonResultElementFactory elementFactory = new GsonResultElementFactory(ODataGsonBuilder.newGsonBuilder());
        return (ODataServiceError)HttpEntityReader.read(result, (CheckedFunction1 & Serializable)root -> {
            JsonObject error = root.getAsJsonObject().get("error").getAsJsonObject();
            GsonResultObject errorObject = new GsonResultObject(error, elementFactory);
            return ODataServiceError.fromResultObject((ResultObject)errorObject, result.getODataRequest().getProtocol());
        });
    }
}

