/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.request;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataRequestException;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ODataResourcePath;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataEntityKey;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataHttpRequest;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataRequestResultGeneric;
import com.sap.cloud.sdk.datamodel.odata.client.request.ODataUriFactory;
import com.sap.cloud.sdk.datamodel.odata.client.request.UpdateStrategy;
import com.sap.cloud.sdk.datamodel.odata.client.request.UriEncodingStrategy;
import io.vavr.CheckedFunction0;
import io.vavr.control.Try;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ODataRequestUpdate
extends ODataRequestGeneric {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ODataRequestUpdate.class);
    @Nonnull
    private final HttpEntity requestHttpEntity;
    @Nonnull
    private UpdateStrategy updateStrategy;
    @Nullable
    private final String versionIdentifier;

    public ODataRequestUpdate(@Nonnull String servicePath, @Nonnull String entityName, @Nonnull ODataEntityKey entityKey, @Nonnull String serializedEntity, @Nonnull UpdateStrategy updateStrategy, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        this(servicePath, ODataResourcePath.of(entityName, entityKey), serializedEntity, updateStrategy, versionIdentifier, protocol);
    }

    public ODataRequestUpdate(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nonnull String serializedEntity, @Nonnull UpdateStrategy updateStrategy, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        this(servicePath, entityPath, new ComparableHttpEntity(serializedEntity), updateStrategy, versionIdentifier, protocol);
    }

    public ODataRequestUpdate(@Nonnull String servicePath, @Nonnull ODataResourcePath entityPath, @Nonnull HttpEntity httpEntity, @Nonnull UpdateStrategy updateStrategy, @Nullable String versionIdentifier, @Nonnull ODataProtocol protocol) {
        super(servicePath, entityPath, protocol);
        this.requestHttpEntity = httpEntity;
        this.updateStrategy = updateStrategy;
        this.versionIdentifier = versionIdentifier;
        Header contentType = httpEntity.getContentType();
        if (contentType != null) {
            this.headers.putIfAbsent("Content-Type", Lists.newArrayList((Object[])new String[]{contentType.getValue()}));
        }
    }

    @Override
    @Nonnull
    public URI getRelativeUri(@Nonnull UriEncodingStrategy strategy) {
        return ODataUriFactory.createAndEncodeUri(this.getServicePath(), this.getResourcePath(), this.getRequestQuery(), strategy);
    }

    @Override
    @Nonnull
    public ODataRequestResultGeneric execute(@Nonnull HttpClient httpClient) {
        ODataHttpRequest request = ODataHttpRequest.forHttpEntity(this, httpClient, this.requestHttpEntity);
        this.addVersionIdentifierToHeaderIfPresent(this.versionIdentifier);
        switch (this.updateStrategy) {
            case MODIFY_WITH_PATCH: 
            case MODIFY_WITH_PATCH_RECURSIVE_DELTA: 
            case MODIFY_WITH_PATCH_RECURSIVE_FULL: {
                return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPatch).get();
            }
            case REPLACE_WITH_PUT: {
                return (ODataRequestResultGeneric)this.tryExecuteWithCsrfToken(httpClient, request::requestPut).get();
            }
        }
        throw new IllegalStateException("Unexpected update Strategy: " + String.valueOf((Object)this.updateStrategy));
    }

    @Nonnull
    public String getSerializedEntity() {
        return (String)Try.of((CheckedFunction0 & Serializable)() -> EntityUtils.toString((HttpEntity)this.requestHttpEntity, (Charset)StandardCharsets.UTF_8)).getOrElseThrow(e -> new ODataRequestException(this, "Unable to serialize request payload.", (Throwable)e));
    }

    @Nonnull
    @Generated
    public UpdateStrategy getUpdateStrategy() {
        return this.updateStrategy;
    }

    @Nullable
    @Generated
    public String getVersionIdentifier() {
        return this.versionIdentifier;
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ODataRequestUpdate)) {
            return false;
        }
        ODataRequestUpdate other = (ODataRequestUpdate)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpEntity this$requestHttpEntity = this.requestHttpEntity;
        HttpEntity other$requestHttpEntity = other.requestHttpEntity;
        if (this$requestHttpEntity == null ? other$requestHttpEntity != null : !this$requestHttpEntity.equals(other$requestHttpEntity)) {
            return false;
        }
        UpdateStrategy this$updateStrategy = this.getUpdateStrategy();
        UpdateStrategy other$updateStrategy = other.getUpdateStrategy();
        if (this$updateStrategy == null ? other$updateStrategy != null : !((Object)((Object)this$updateStrategy)).equals((Object)other$updateStrategy)) {
            return false;
        }
        String this$versionIdentifier = this.getVersionIdentifier();
        String other$versionIdentifier = other.getVersionIdentifier();
        return !(this$versionIdentifier == null ? other$versionIdentifier != null : !this$versionIdentifier.equals(other$versionIdentifier));
    }

    @Override
    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ODataRequestUpdate;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpEntity $requestHttpEntity = this.requestHttpEntity;
        result = result * 59 + ($requestHttpEntity == null ? 43 : $requestHttpEntity.hashCode());
        UpdateStrategy $updateStrategy = this.getUpdateStrategy();
        result = result * 59 + ($updateStrategy == null ? 43 : ((Object)((Object)$updateStrategy)).hashCode());
        String $versionIdentifier = this.getVersionIdentifier();
        result = result * 59 + ($versionIdentifier == null ? 43 : $versionIdentifier.hashCode());
        return result;
    }

    @Generated
    public void setUpdateStrategy(@Nonnull UpdateStrategy updateStrategy) {
        if (updateStrategy == null) {
            throw new NullPointerException("updateStrategy is marked non-null but is null");
        }
        this.updateStrategy = updateStrategy;
    }

    private static class ComparableHttpEntity
    implements HttpEntity {
        @Nonnull
        private final Object data;
        @Nonnull
        private final HttpEntity delegate;

        private ComparableHttpEntity(String json) {
            this(json, (HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            ((StringEntity)this.delegate).setContentType(ContentType.APPLICATION_JSON.getMimeType());
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ComparableHttpEntity)) {
                return false;
            }
            ComparableHttpEntity other = (ComparableHttpEntity)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Object this$data = this.data;
            Object other$data = other.data;
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(@Nullable Object other) {
            return other instanceof ComparableHttpEntity;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $data = this.data;
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public ComparableHttpEntity(@Nonnull Object data, @Nonnull HttpEntity delegate) {
            if (data == null) {
                throw new NullPointerException("data is marked non-null but is null");
            }
            if (delegate == null) {
                throw new NullPointerException("delegate is marked non-null but is null");
            }
            this.data = data;
            this.delegate = delegate;
        }

        @Generated
        public boolean isRepeatable() {
            return this.delegate.isRepeatable();
        }

        @Generated
        public boolean isChunked() {
            return this.delegate.isChunked();
        }

        @Generated
        public long getContentLength() {
            return this.delegate.getContentLength();
        }

        @Generated
        public Header getContentType() {
            return this.delegate.getContentType();
        }

        @Generated
        public Header getContentEncoding() {
            return this.delegate.getContentEncoding();
        }

        @Generated
        public InputStream getContent() throws IOException, UnsupportedOperationException {
            return this.delegate.getContent();
        }

        @Generated
        public void writeTo(OutputStream arg0) throws IOException {
            this.delegate.writeTo(arg0);
        }

        @Generated
        public boolean isStreaming() {
            return this.delegate.isStreaming();
        }

        @Deprecated
        @Generated
        public void consumeContent() throws IOException {
            this.delegate.consumeContent();
        }
    }
}

