/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.datamodel.odata.client.expression;

import com.google.common.collect.Lists;
import com.sap.cloud.sdk.datamodel.odata.client.ODataProtocol;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FieldReference;
import com.sap.cloud.sdk.datamodel.odata.client.expression.FilterExpression;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBinary;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueBoolean;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDate;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDateTime;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDateTimeOffset;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueDuration;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueGuid;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueNumeric;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueString;
import com.sap.cloud.sdk.datamodel.odata.client.expression.ValueTimeOfDay;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lombok.Generated;

public class Expressions {
    static FilterExpression createOperatorPrefix(@Nonnull String operator, @Nonnull Operand operand) {
        return new DefaultFilterExpression("(%s %s)", operator, Collections.singletonList(operand));
    }

    static FilterExpression createFunctionPrefix(@Nonnull String operator) {
        return new DefaultFilterExpression("%s()", operator, Collections.emptyList());
    }

    static FilterExpression createFunctionPrefix(@Nonnull String operator, @Nonnull Operand operand) {
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand});
        return new DefaultFilterExpression("%s(%s)", operator, operands);
    }

    static FilterExpression createFunctionPrefix(@Nonnull String operator, @Nonnull Operand operand1, @Nonnull Operand operand2) {
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand1, operand2});
        return new DefaultFilterExpression("%s(%s,%s)", operator, operands);
    }

    static FilterExpression createFunctionPrefix(@Nonnull String operator, @Nonnull Operand operand1, @Nonnull Operand operand2, @Nonnull Operand operand3) {
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand1, operand2, operand3});
        return new DefaultFilterExpression("%s(%s,%s,%s)", operator, operands);
    }

    static FilterExpression createFunctionInfix(@Nonnull String operator, @Nonnull Operand operand1, @Nonnull Operand operand2) {
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand1, operand2});
        return new DefaultFilterExpression("(%2$s %1$s %3$s)", operator, operands);
    }

    static FilterExpression createFunctionLambda(@Nonnull String operator, @Nonnull OperandMultiple operand1) {
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand1});
        return new DefaultFilterExpression("%2$s/%1$s()", operator, operands);
    }

    static FilterExpression createFunctionLambda(@Nonnull String operator, @Nonnull OperandMultiple operand1, final @Nonnull Operand operand2, final @Nonnull Predicate<FieldReference> lambdaFieldPredicate) {
        String format = "%2$s/%1$s(%3$s)";
        Operand operandLambda = new Operand(){

            @Override
            @Nonnull
            public String getExpression(@Nonnull ODataProtocol protocol, @Nonnull Map<String, Predicate<FieldReference>> prefixes) {
                String lambdaFieldPrefix = "" + (char)(97 + prefixes.size());
                LinkedHashMap<String, Predicate<FieldReference>> prefx = new LinkedHashMap<String, Predicate<FieldReference>>();
                prefx.put(lambdaFieldPrefix, lambdaFieldPredicate);
                prefx.putAll(prefixes);
                return lambdaFieldPrefix + ":" + operand2.getExpression(protocol, prefx);
            }
        };
        ArrayList operands = Lists.newArrayList((Object[])new Operand[]{operand1, operandLambda});
        return new DefaultFilterExpression("%2$s/%1$s(%3$s)", operator, operands);
    }

    @Nonnull
    public static <PrimitiveT> OperandSingle createOperand(@Nullable PrimitiveT value) {
        if (value == null) {
            return (protocol, prefixes) -> "null";
        }
        if (value instanceof OperandSingle) {
            return (OperandSingle)value;
        }
        if (value instanceof String) {
            return ValueString.literal((String)value);
        }
        if (value instanceof Boolean) {
            return ValueBoolean.literal((Boolean)value);
        }
        if (value instanceof Number) {
            return ValueNumeric.literal((Number)value);
        }
        if (value instanceof Duration) {
            return ValueDuration.literal((Duration)value);
        }
        if (value instanceof LocalDateTime) {
            return ValueDateTime.literal((LocalDateTime)value);
        }
        if (value instanceof OffsetDateTime) {
            return ValueDateTimeOffset.literal((OffsetDateTime)value);
        }
        if (value instanceof ZonedDateTime) {
            return ValueDateTimeOffset.literal(OffsetDateTime.from((TemporalAccessor)value));
        }
        if (value instanceof LocalDate) {
            return ValueDate.literal((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return ValueTimeOfDay.literal((LocalTime)value);
        }
        if (value instanceof UUID) {
            return ValueGuid.literal((UUID)value);
        }
        if (value instanceof byte[]) {
            return ValueBinary.literal((byte[])value);
        }
        throw new IllegalArgumentException("Unable to create filter expression for value " + value);
    }

    private static class DefaultFilterExpression
    implements FilterExpression {
        @Nonnull
        private final String format;
        @Nonnull
        private final String operator;
        @Nonnull
        private final List<Operand> operands;

        @Override
        @Nonnull
        public String getExpression(@Nonnull ODataProtocol protocol, @Nonnull Map<String, Predicate<FieldReference>> prefixes) {
            List parts = this.getOperands().stream().map(o -> o.getExpression(protocol, prefixes)).collect(Collectors.toList());
            parts.add(0, this.getOperator());
            return String.format(this.format, parts.toArray());
        }

        @Generated
        public DefaultFilterExpression(@Nonnull String format, @Nonnull String operator, @Nonnull List<Operand> operands) {
            if (format == null) {
                throw new NullPointerException("format is marked non-null but is null");
            }
            if (operator == null) {
                throw new NullPointerException("operator is marked non-null but is null");
            }
            if (operands == null) {
                throw new NullPointerException("operands is marked non-null but is null");
            }
            this.format = format;
            this.operator = operator;
            this.operands = operands;
        }

        @Override
        @Nonnull
        @Generated
        public String getOperator() {
            return this.operator;
        }

        @Override
        @Nonnull
        @Generated
        public List<Operand> getOperands() {
            return this.operands;
        }
    }

    @FunctionalInterface
    public static interface Operand {
        public static final Operand NULL = (protocol, prefixes) -> "null";

        @Nonnull
        default public String getExpression(@Nonnull ODataProtocol protocol) {
            return this.getExpression(protocol, Collections.emptyMap());
        }

        @Nonnull
        public String getExpression(@Nonnull ODataProtocol var1, @Nonnull Map<String, Predicate<FieldReference>> var2);
    }

    public static interface OperandSingle
    extends Operand {
    }

    public static interface OperandMultiple
    extends Operand {
    }
}

