/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.s4hana.connectivity.soap;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.sap.cloud.sdk.cloudplatform.connectivity.Destination;
import com.sap.cloud.sdk.cloudplatform.connectivity.Header;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestination;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.cloudplatform.connectivity.ProxyConfiguration;
import com.sap.cloud.sdk.s4hana.connectivity.ErpHttpDestinationProperties;
import com.sap.cloud.sdk.s4hana.connectivity.ErpHttpDestinationUtils;
import com.sap.cloud.sdk.s4hana.connectivity.soap.DefaultHttpClientTransportSender;
import com.sap.cloud.sdk.s4hana.connectivity.soap.SoapException;
import com.sap.cloud.sdk.s4hana.serialization.SapClient;
import io.vavr.CheckedFunction1;
import io.vavr.control.Option;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import lombok.Generated;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.databinding.utils.ConverterUtil;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.transport.TransportSender;
import org.apache.axis2.transport.http.HttpTransportProperties;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustAllStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SoapRequest<ServiceT extends Stub> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SoapRequest.class);
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final int MAX_TOTAL_CONNECTIONS = 200;
    private static final int MAX_CONNECTIONS_PER_ROUTE = 100;
    private final ServiceT service;

    public static void registerCustomConverter(@Nonnull Class<? extends ConverterUtil> customConverter) throws SoapException {
        try {
            if (log.isDebugEnabled()) {
                log.debug("Registering Axis2 custom converter class " + customConverter.getSimpleName() + ".");
            }
            Field isCustomClassPresentField = ConverterUtil.class.getDeclaredField("isCustomClassPresent");
            isCustomClassPresentField.setAccessible(true);
            isCustomClassPresentField.setBoolean(null, true);
            isCustomClassPresentField.setAccessible(false);
            Field customClassField = ConverterUtil.class.getDeclaredField("customClass");
            customClassField.setAccessible(true);
            customClassField.set(null, customConverter);
            customClassField.setAccessible(false);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new SoapException("Error while registering Custom Converter class " + customConverter.getSimpleName() + " in the Axis2 library.", e);
        }
    }

    @Deprecated
    public SoapRequest(@Nonnull Class<ServiceT> serviceClass, @Nonnull Destination destination) throws SoapException {
        this.service = this.instantiateServiceClass(serviceClass, this.getServiceConfigurationContext());
        this.prepareSoapCall(this.service, destination.asHttp());
    }

    public SoapRequest(@Nonnull Class<ServiceT> serviceClass, @Nonnull HttpDestination httpDestination) throws SoapException {
        this.service = this.instantiateServiceClass(serviceClass, this.getServiceConfigurationContext());
        this.prepareSoapCall(this.service, httpDestination);
    }

    @Nonnull
    private ServiceT instantiateServiceClass(@Nonnull Class<ServiceT> serviceClass, @Nonnull ConfigurationContext configurationContext) throws SoapException {
        try {
            return (ServiceT)((Stub)serviceClass.getConstructor(ConfigurationContext.class).newInstance(configurationContext));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new SoapException("Error during constructor invocation of class " + serviceClass.getSimpleName() + ".", e);
        }
    }

    @Nonnull
    private ConfigurationContext getServiceConfigurationContext() throws SoapException {
        try {
            ConfigurationContext configurationContext = ConfigurationContextFactory.createDefaultConfigurationContext();
            this.specifyUsageOfHttpClient4(configurationContext);
            return configurationContext;
        }
        catch (Exception e) {
            throw new SoapException("Error while preparing Axis2 configuration context: " + e.getMessage() + ".", e);
        }
    }

    private void specifyUsageOfHttpClient4(@Nonnull ConfigurationContext configurationContext) throws SoapException {
        AxisConfiguration axisConfiguration = configurationContext.getAxisConfiguration();
        ((TransportOutDescription)axisConfiguration.getTransportsOut().get("https")).setSender((TransportSender)new DefaultHttpClientTransportSender());
        ((TransportOutDescription)axisConfiguration.getTransportsOut().get("http")).setSender((TransportSender)new DefaultHttpClientTransportSender());
        HashMap transportsOut = axisConfiguration.getTransportsOut();
        for (TransportOutDescription transportOut : transportsOut.values()) {
            TransportSender sender = transportOut.getSender();
            if (sender == null) continue;
            try {
                sender.init(configurationContext, transportOut);
            }
            catch (AxisFault e) {
                throw new SoapException("Error while initializing Axis2 library.", e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(DefaultHttpClientTransportSender.class.getSimpleName() + " set in Axis2 configuration.");
        }
    }

    private void prepareSoapCall(@Nonnull ServiceT service, @Nonnull HttpDestination destination) throws SoapException {
        try {
            this.setTargetUriOfSoapCallFromDestination(service, (ErpHttpDestinationProperties)destination.decorate(ErpHttpDestinationUtils.asErp()));
            this.setHeadersOfSoapCall(service, destination);
            this.setProxyOfSoapCall(service, (HttpDestinationProperties)destination);
            this.setTrustAllOfSoapCall(service, destination);
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw new SoapException(e);
        }
    }

    private void setTrustAllOfSoapCall(@Nonnull ServiceT service, @Nonnull HttpDestination destination) throws UnrecoverableKeyException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (destination.isTrustingAllCertificates()) {
            TrustAllSslSocketFactory socketFactory = new TrustAllSslSocketFactory(destination);
            ClientConnectionManager connectionManager = this.buildConnectionManager(socketFactory);
            service._getServiceClient().getOptions().setProperty("MULTITHREAD_HTTP_CONNECTION_MANAGER", (Object)connectionManager);
        }
    }

    @Nonnull
    private ClientConnectionManager buildConnectionManager(@Nonnull TrustAllSslSocketFactory socketFactory) {
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)socketFactory));
        ThreadSafeClientConnManager connectionManager = new ThreadSafeClientConnManager(schemeRegistry);
        connectionManager.setMaxTotal(200);
        connectionManager.setDefaultMaxPerRoute(100);
        return connectionManager;
    }

    private void setProxyOfSoapCall(@Nonnull ServiceT service, @Nonnull HttpDestinationProperties destination) {
        Option proxyConfiguration = destination.getProxyConfiguration();
        if (proxyConfiguration.isDefined()) {
            String proxyHost = ((ProxyConfiguration)proxyConfiguration.get()).getUri().getHost();
            int proxyPort = ((ProxyConfiguration)proxyConfiguration.get()).getUri().getPort();
            HttpTransportProperties.ProxyProperties proxyProperties = new HttpTransportProperties.ProxyProperties();
            proxyProperties.setProxyName(proxyHost);
            proxyProperties.setProxyPort(proxyPort);
            service._getServiceClient().getOptions().setProperty("PROXY", (Object)proxyProperties);
            if (log.isDebugEnabled()) {
                log.debug("Setting proxy for SOAP call: " + proxyHost + ":" + proxyPort + ".");
            }
        }
    }

    private void setTargetUriOfSoapCallFromDestination(@Nonnull ServiceT service, @Nonnull ErpHttpDestinationProperties destination) throws SoapException {
        URI targetUri;
        URI originalSoapUri = this.getTargetUriOfSoapCall(service);
        if (log.isDebugEnabled()) {
            log.debug("Original SOAP service URI from WSDL file: " + originalSoapUri + ".");
        }
        ArrayList queryStringParams = Lists.newArrayList();
        if (destination.getSapClient().isDefined()) {
            queryStringParams.add(new BasicNameValuePair("sap-client", ((SapClient)destination.getSapClient().get()).getValue()));
        }
        queryStringParams.add(new BasicNameValuePair("sap-language", destination.getLocale().toString()));
        URI destinationUri = destination.getUri();
        try {
            targetUri = new URIBuilder().setScheme(destinationUri.getScheme()).setUserInfo(destinationUri.getUserInfo()).setHost(destinationUri.getHost()).setPort(destinationUri.getPort()).setPath(originalSoapUri.getPath()).setParameters((List)queryStringParams).build();
        }
        catch (URISyntaxException e) {
            throw new SoapException("Error while constructing target URI of SOAP service.", e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Determined target URI of SOAP service: " + targetUri + ".");
        }
        this.setTargetUriOfSoapCall(service, targetUri);
    }

    private void setHeadersOfSoapCall(@Nonnull ServiceT service, @Nonnull HttpDestination destination) {
        HashMap soapHeaders = Maps.newHashMap();
        Collection destinationHeaders = destination.getHeaders(destination.getUri());
        for (Header header : destinationHeaders) {
            soapHeaders.put(header.getName(), header.getValue());
        }
        service._getServiceClient().getOptions().setProperty("HTTP_HEADERS", (Object)soapHeaders);
    }

    private URI getTargetUriOfSoapCall(@Nonnull ServiceT service) throws SoapException {
        URI targetUri;
        String address = service._getServiceClient().getOptions().getTo().getAddress();
        if (address.isEmpty()) {
            throw new SoapException("URI pointing to SOAP service is empty. Ensure that XML attribute location of the XML tag soap:address inside the respective WSDL file contains as valid URI.");
        }
        try {
            targetUri = new URI(address);
        }
        catch (URISyntaxException e) {
            throw new SoapException("Error while reading target URI of SOAP service coming from WSDL: " + address + " is not a valid URI.", e);
        }
        return targetUri;
    }

    private void setTargetUriOfSoapCall(@Nonnull ServiceT service, @Nonnull URI targetUri) {
        service._getServiceClient().getOptions().getTo().setAddress(targetUri.toString());
    }

    @Nonnull
    public <ReturnT> ReturnT execute(@Nonnull CheckedFunction1<ServiceT, ReturnT> function) throws SoapException {
        try {
            return (ReturnT)function.apply(this.service);
        }
        catch (SoapException t) {
            throw t;
        }
        catch (Throwable t) {
            throw new SoapException(t);
        }
    }

    private static class TrustAllManager
    implements X509TrustManager {
        private TrustAllManager() {
        }

        @Override
        public void checkClientTrusted(@Nullable X509Certificate[] x509Certificates, @Nullable String s) {
        }

        @Override
        public void checkServerTrusted(@Nullable X509Certificate[] x509Certificates, @Nullable String s) {
        }

        @Override
        @Nonnull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    private static class TrustAllSslSocketFactory
    extends SSLSocketFactory {
        TrustAllSslSocketFactory(HttpDestination destination) throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException, UnrecoverableKeyException {
            super((TrustStrategy)new TrustAllStrategy(), (X509HostnameVerifier)new AllowAllHostnameVerifier());
            Option tlsVersion = destination.getTlsVersion();
            SSLContext sslContext = SSLContext.getInstance((String)tlsVersion.getOrElse((Object)"TLSv1.2"));
            TrustAllManager trustAllTrustManager = new TrustAllManager();
            sslContext.init(null, new TrustManager[]{trustAllTrustManager}, null);
        }
    }
}

