/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cloud.sdk.frameworks.resilience4j;

import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceConfiguration;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationKey;
import com.sap.cloud.sdk.cloudplatform.resilience.ResilienceIsolationMode;
import com.sap.cloud.sdk.frameworks.resilience4j.GenericDecorator;
import com.sap.cloud.sdk.frameworks.resilience4j.RetryProvider;
import io.github.resilience4j.retry.Retry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class DefaultRetryProvider
implements RetryProvider,
GenericDecorator {
    private static final RetryConfig DEFAULT_RETRY_CONFIG = RetryConfig.custom().build();
    private final ConcurrentMap<ResilienceIsolationKey, RetryRegistry> retryRegistries = new ConcurrentHashMap<ResilienceIsolationKey, RetryRegistry>();

    private RetryRegistry getRetryRegistry(@Nonnull ResilienceIsolationKey isolationKey) {
        return this.retryRegistries.computeIfAbsent(isolationKey, k -> RetryRegistry.of((RetryConfig)DEFAULT_RETRY_CONFIG));
    }

    @Override
    @Nonnull
    public Retry getRetry(@Nonnull ResilienceConfiguration configuration) {
        String identifier = configuration.identifier();
        ResilienceIsolationKey isolationKey = ResilienceIsolationKey.of((ResilienceIsolationMode)configuration.isolationMode());
        RetryRegistry retryRegistry = this.getRetryRegistry(isolationKey);
        RetryConfig customRetryConfig = RetryConfig.custom().maxAttempts(configuration.retryConfiguration().maxAttempts()).waitDuration(configuration.retryConfiguration().waitDuration()).retryOnException(configuration.retryConfiguration().retryOnExceptionPredicate()).build();
        return retryRegistry.retry(identifier, customRetryConfig);
    }

    @Override
    @Nonnull
    public <T> Callable<T> decorateCallable(@Nonnull Callable<T> callable, @Nonnull ResilienceConfiguration configuration) {
        if (!configuration.retryConfiguration().isEnabled()) {
            return callable;
        }
        Retry retry = this.getRetry(configuration);
        return Retry.decorateCallable((Retry)retry, callable);
    }
}

